DO $unpackage_if_needed$
BEGIN
	IF EXISTS (
		select t.typname from pg_catalog.pg_depend d, pg_catalog.pg_extension e, pg_catalog.pg_type t where
		e.extname = 'postgis' and d.refclassid =
		'pg_catalog.pg_extension'::pg_catalog.regclass and d.refobjid = e.oid
		and d.classid = 'pg_catalog.pg_type'::pg_catalog.regclass and d.objid = t.oid
		and t.typname = 'raster'
	) THEN

		RAISE WARNING 'unpackaging raster';

		EXECUTE $unpackage$
		-- UNPACKAGE_CODE --
DO $$ BEGIN ALTER EXTENSION postgis DROP CAST (raster AS bytea);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bytea(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP CAST (raster AS box2d);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION box2d(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP CAST (raster AS geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_MapAlgebra(raster, integer, text, text, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_MapAlgebraExpr(raster, integer, text, text, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_MapAlgebraExpr(raster, text, text, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_MapAlgebraFctNgb(raster, integer, text, integer, integer, regprocedure, text, text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_AsRaster(geometry , integer , integer , double precision , double precision , text , double precision , double precision , double precision , double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_AsRaster(geometry , integer , integer , text[] , double precision[] , double precision[] , double precision , double precision , double precision , double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_AsRaster(geometry , integer , integer , text , double precision , double precision , double precision , double precision , double precision , double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_AsRaster(geometry , integer , integer , double precision , double precision , text[] , double precision[] , double precision[] , double precision , double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_AsRaster(geometry , integer , integer , double precision , double precision , text[] , double precision[] , double precision[] , double precision , double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_AsRaster(geometry , double precision , double precision , text , double precision , double precision , double precision , double precision , double precision , double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_AsRaster(geometry , raster , text , double precision , double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _ST_AsRaster(geometry,double precision , double precision, integer , integer,text[] , double precision[] ,double precision[] ,  double precision,  double precision, double precision,double precision, double precision, double precision, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _ST_Resample(raster, text, double precision, integer, double precision, double precision, double precision, double precision, double precision, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Resample(raster, raster, text, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_HasNoBand(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_BandMetaData(raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_BandNoDataValue(raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_BandNoDataValue(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_SetGeoReference(raster, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_SetGeoReference(raster, text, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setbandisnodata(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setbandisnodata(raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setbandnodatavalue(raster, integer, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setbandnodatavalue(raster, integer, double precision, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_dumpaspolygons(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_dumpaspolygons(raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_polygon(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_polygon(raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_makeemptyraster(int, int, float8, float8, float8, float8, float8, float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_makeemptyraster(int, int, float8, float8, float8, float8, float8, float8, int4);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband(raster, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband(raster, text, float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband(raster, int, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband(raster, int, text, float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband(raster, raster, int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband(raster, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband(raster, text, float8, float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband(raster, int, text, float8, float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband(raster, raster, int, int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandisnodata(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandisnodata(raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandisnodata(raster, integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandpath(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandpath(raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandpixeltype(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandpixeltype(raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value(raster, integer, integer, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value(raster, integer, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value(raster, integer, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value(raster, integer, integer, integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value(raster, integer, integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value(raster, integer, geometry, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value(raster, integer, geometry, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value(raster, geometry, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_georeference(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_georeference(raster, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION dumpaswktpolygons(raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandmetadata(raster, int[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_PixelAsPolygons(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_PixelAsPolygons(raster,integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_summarystats(raster,int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_summarystats(raster, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats(raster,int, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats(raster,int, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats(raster, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats(raster, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_summarystats(text, text,integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_summarystats(text, text, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats(text, text,integer, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats(text, text,integer, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats(text, text, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats(text, text, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_summarystats(raster,int, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_summarystats(text, text,integer, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(raster, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(raster, double precision, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(raster, int, boolean, double precision, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(raster, int, double precision, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(text, text, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(text, text, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(text, text, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(text, text, double precision, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(text, text, double precision, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(text, text, int, boolean, double precision, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(text, text, int, double precision, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(text, text, integer, boolean, double precision, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(text, text, integer, double precision, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile(raster, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile(raster, int, boolean, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_quantile(raster, int, boolean, double precision, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile(raster, int, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile(text, text, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile(text, text, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile(text, text, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile(text, text, int, boolean, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_quantile(text, text, int, boolean, double precision, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile(text, text, int, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile(text, text, int, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile(text, text, int, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP TYPE quantile;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount(text, text, integer, double precision, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount(text, text, integer, boolean, double precision[], double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount(text, text, double precision[], double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount(text, text, integer, double precision[], double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount(text, text, integer, boolean, double precision, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount(text, text, double precision, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount(raster, integer, boolean, double precision[], double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount(raster, integer, double precision[], double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount(raster, double precision[], double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_valuecount(text, text, integer, boolean, double precision[], double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_valuecount(raster, integer, boolean, double precision[], double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP TYPE valuecount;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram(raster, int, boolean, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram(raster, int, boolean, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram(raster, int, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram(raster, int, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram( raster, int, boolean, double precision, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(raster, int, boolean, double precision, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(raster, int, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(raster, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(raster, int, double precision, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(raster, int, double precision, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram(text, text, int, boolean, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram(text, text, int, boolean, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram(text, text, int, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram(text, text, int, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram( text, text, int, boolean, double precision, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(text, text, int, boolean, double precision, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(text, text, int, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(text, text, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(text, text, int, double precision, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(text, text, int, double precision, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_histogram( raster, int, boolean, double precision, int, double precision[], boolean, double precision, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_histogram( text, text, int, boolean, double precision, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP TYPE histogram;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP TYPE bandmetadata;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP TYPE geomvalxy;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _rename_raster_tables();EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _rename_raster_tables();EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP VIEW raster_columns;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION AddRasterColumn(varchar, varchar, varchar, varchar, integer, varchar[], boolean, boolean, double precision[], double precision, double precision, integer, integer, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION AddRasterColumn(varchar, varchar, varchar, integer, varchar[], boolean, boolean, double precision[], double precision, double precision, integer, integer, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION AddRasterColumn(varchar, varchar, integer, varchar[], boolean, boolean, double precision[], double precision, double precision, integer, integer, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION DropRasterColumn(varchar, varchar, varchar, varchar);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION DropRasterColumn(varchar, varchar, varchar);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION DropRasterColumn(varchar, varchar);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION DropRasterTable(varchar, varchar, varchar);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION DropRasterTable(varchar, varchar);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION DropRasterTable(varchar);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION AddRasterConstraints(name, name, name, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION AddRasterConstraints(name, name, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION DropRasterConstraints(name, name, name, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION DropRasterConstraints(name, name, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _drop_st_samealignment();EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection(raster, integer, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection(raster, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_minpossibleval(text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_pixelaspolygon(raster, integer, integer, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection(raster, int, geometry, text, regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection(raster, int, geometry, regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection(raster, geometry, text, regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection(raster, geometry, regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_dumpaswktpolygons(raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP TYPE wktgeomval;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_nearestvalue(raster, integer, integer, integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_nearestvalue(raster, integer, integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_neighborhood(raster, integer, integer, integer, integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_neighborhood(raster, integer, integer, integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_neighborhood(raster, integer, geometry, integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_neighborhood(raster, geometry, integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection(raster, integer, raster, integer, text, regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection(raster, integer, raster, integer, regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection(raster, raster, text, regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection(raster, raster, regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_pixelaspolygons(raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandsurface(raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_overlaps(geometry, raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_overlaps(raster, integer, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_overlaps(raster, geometry, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_overlaps(raster, geometry, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_overlaps(geometry, raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_touches(geometry, raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_touches(raster, geometry, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_touches(raster, integer, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_touches(geometry, raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_touches(raster, geometry, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_contains(raster, geometry, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_contains(raster, integer, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_contains(geometry, raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_contains(raster, geometry, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_contains(geometry, raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband(raster, raster[], integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_hillshade(raster, integer, text, double precision, double precision, double precision, double precision, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_hillshade(raster, integer, text, float, float, float, float, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_hillshade(raster, integer, text, float, float, float, float);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_tile(raster, integer, integer, integer[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_tile(raster, integer, integer, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setvalue(raster, integer, geometry, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setvalue(raster, geometry, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_world2rastercoord(raster, double precision, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_world2rastercoord(raster, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_world2rastercoord(raster, double precision, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_world2rastercoordx(raster, float8, float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_world2rastercoordx(raster, float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_world2rastercoordx(raster, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_world2rastercoordy(raster, float8, float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_world2rastercoordy(raster, float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_world2rastercoordy(raster, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_raster2worldcoord( raster, integer, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_raster2worldcoord(raster, integer, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_raster2worldcoordx(raster, int, int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_raster2worldcoordx(raster, int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_raster2worldcoordy(raster, int, int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_raster2worldcoordy(raster, int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_resample(raster, text, double precision, integer, double precision, double precision, double precision, double precision, double precision, double precision, integer, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_resample(raster, integer, double precision, double precision, double precision, double precision, double precision, double precision, text, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_resample(raster, integer, integer, integer, double precision, double precision, double precision, double precision, text, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_tile(raster, integer, integer, int[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_tile(raster, integer[], integer, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_tile(raster, integer, integer, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_tile(raster, integer, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _add_raster_constraint_regular_blocking(name, name, name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asbinary(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_hillshade4ma(float8[], text, text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_gdaldrivers();EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandmetadata(raster, int[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandmetadata(raster, int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(raster, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE ST_Union(raster, text, text, text, double precision, text, text, text, double precision, text, text, text, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE ST_Union(raster, text, text, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE ST_Union(raster, text, text, text, double precision, text, text, text, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE ST_Union(raster, text, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE ST_Union(raster, text, text, text, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE ST_Union(raster, record[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Intersects(raster,boolean,geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Intersects(geometry,raster,boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Intersects(raster,geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Intersects(geometry,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Intersects(raster, integer, boolean, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Intersects(geometry, raster, integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_intersects(raster, geometry, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_slope4ma(float8[], text, text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_slope(raster, integer, text, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_aspect4ma(float8[], text, text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_aspect(raster, integer, text, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Intersection(raster,raster, integer, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Intersection(geometry,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_MapAlgebraFct(raster, raster, regprocedure, text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_mapalgebra4unionfinal1(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_mapalgebra4unionstate(raster, raster, int4);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_mapalgebra4unionstate(raster, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_mapalgebra4unionstate(raster, raster, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_mapalgebra4unionstate(raster, raster, int4, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_mapalgebra4unionstate(raster, raster, text, text, text, float8, text, text, text, float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_clip(raster, int, geometry, float8[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_mapalgebra(rastbandarg[],regprocedure,text,integer,integer,text,raster,text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_count(text, text, integer, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_count(text, text, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_count(text, text, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxcount(text, text, int, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxcount(text, text, int, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxcount(text, text, int, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxcount(text, text, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxcount(text, text, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_summarystats(text, text, integer, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_summarystats(text, text, integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_summarystats(text, text, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats(text, text, integer, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats(text, text, integer, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats(text, text, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats(text, text, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_histogram(text, text, int, boolean, double precision, int,double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram(text, text, int, boolean, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram(text, text, int, boolean, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram(text, text, int, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram(text, text, int, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(text, text, int, boolean, double precision, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(text, text, int, boolean, double precision, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(text, text, int,double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(text, text, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(text, text, int, double precision, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(text, text, int, double precision, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile(rastertable text, rastercolumn text, nband integer, exclude_nodata_value boolean, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile(rastertable text, rastercolumn text, nband integer, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile(rastertable text, rastercolumn text, exclude_nodata_value boolean, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile(rastertable text, rastercolumn text, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(rastertable text, rastercolumn text, nband integer, exclude_nodata_value boolean, sample_percent double precision, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(rastertable text, rastercolumn text, nband integer, sample_percent double precision, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(rastertable text, rastercolumn text, sample_percent double precision, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(rastertable text, rastercolumn text, exclude_nodata_value boolean, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(rastertable text, rastercolumn text, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value(rast raster, band integer, pt geometry, exclude_nodata_value boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_gdalopenoptions(text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_clip(rast raster, geom geometry, nodataval float8[], crop boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP VIEW raster_columns;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP VIEW raster_overviews;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE st_summarystatsagg (raster, integer, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE st_summarystatsagg (raster, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE st_summarystatsagg (raster, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE st_countagg (raster, integer, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE st_countagg (raster, integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE st_countagg (raster, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE st_samealignment (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE st_union (raster, unionarg[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE st_union (raster, integer, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE st_union (raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE st_union (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE st_union (raster, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE ST_AsRasterAgg (geom geometry, val float8, ref raster, pixeltype text, nodataval float8, uniontype text, touched boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR CLASS hash_raster_ops USING hash;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR FAMILY hash_raster_ops USING hash;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR =  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR <<  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR &<  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR <<|  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR &<|  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR &&  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR &>  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR >>  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR |&>  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR |>>  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR ~=  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR @  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR ~  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR ~  (raster,geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR @  (raster,geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR &&  (raster,geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR ~  (geometry,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR @  (geometry,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR &&  (geometry,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP CAST (raster AS box3d);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP CAST (raster AS geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP CAST (raster AS bytea);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION postgis_raster_lib_version ();EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION postgis_raster_scripts_installed ();EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION postgis_raster_lib_build_date ();EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION postgis_gdal_version ();EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_envelope (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_convexhull (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_minconvexhull (	rast raster,	nband integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION box3d (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_height (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_numbands (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_scalex (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_scaley (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_skewx (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_skewy (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_srid (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_upperleftx (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_upperlefty (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_width (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_pixelwidth (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_pixelheight (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_geotransform (raster,    OUT imag double precision,    OUT jmag double precision,    OUT theta_i double precision,    OUT theta_ij double precision,    OUT xoffset double precision,    OUT yoffset double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_rotation (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_metadata (	rast raster,	OUT upperleftx double precision,	OUT upperlefty double precision,	OUT width int,	OUT height int,	OUT scalex double precision,	OUT scaley double precision,	OUT skewx double precision,	OUT skewy double precision,	OUT srid int,	OUT numbands int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_summary (rast raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_MemSize (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_makeemptyraster (width int, height int, upperleftx float8, upperlefty float8, scalex float8, scaley float8, skewx float8, skewy float8, srid integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_makeemptyraster (width int, height int, upperleftx float8, upperlefty float8, pixelsize float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_makeemptyraster (rast raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband (rast raster, addbandargset addbandarg[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband (	rast raster,	index int,	pixeltype text,	initialvalue float8 ,	nodataval float8 );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband (	rast raster,	pixeltype text,	initialvalue float8 ,	nodataval float8 );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband (	torast raster,	fromrast raster,	fromband int ,	torastindex int );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband (	torast raster,	fromrasts raster[], fromband integer ,	torastindex int );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband (	rast raster,	index int,	outdbfile text, outdbindex int[],	nodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband (	rast raster,	outdbfile text, outdbindex int[],	index int ,	nodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_band (rast raster, nbands int[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_band (rast raster, nband int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_band (rast raster, nbands text, delimiter char );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_summarystats (	rast raster,	nband int ,	exclude_nodata_value boolean ,	sample_percent double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_summarystats (	rast raster,	nband int ,	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_summarystats (	rast raster,	exclude_nodata_value boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats (	rast raster,	nband int ,	exclude_nodata_value boolean ,	sample_percent double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats (	rast raster,	nband int,	sample_percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats (	rast raster,	exclude_nodata_value boolean,	sample_percent double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats (	rast raster,	sample_percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_summarystats_finalfn (internal);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_summarystats_transfn (	internal,	raster, integer,	boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_summarystats_transfn (	internal,	raster, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_summarystats_transfn (	internal,	raster, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_count (rast raster, nband int , exclude_nodata_value boolean , sample_percent double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_count (rast raster, nband int , exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_count (rast raster, exclude_nodata_value boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxcount (rast raster, nband int , exclude_nodata_value boolean , sample_percent double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxcount (rast raster, nband int, sample_percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxcount (rast raster, exclude_nodata_value boolean, sample_percent double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxcount (rast raster, sample_percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_countagg_finalfn (agg agg_count);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION __st_countagg_transfn (	agg agg_count,	rast raster, 	nband integer , exclude_nodata_value boolean ,	sample_percent double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_countagg_transfn (	agg agg_count,	rast raster, 	nband integer, exclude_nodata_value boolean,	sample_percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_countagg_transfn (	agg agg_count,	rast raster, 	nband integer, exclude_nodata_value boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_countagg_transfn (	agg agg_count,	rast raster, 	exclude_nodata_value boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_histogram (	rast raster, nband int ,	exclude_nodata_value boolean ,	sample_percent double precision ,	bins int , width double precision[] ,	right boolean ,	min double precision , max double precision ,	OUT min double precision,	OUT max double precision,	OUT count bigint,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram (	rast raster, nband int ,	exclude_nodata_value boolean ,	bins int , width double precision[] ,	right boolean ,	OUT min double precision,	OUT max double precision,	OUT count bigint,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram (	rast raster, nband int,	exclude_nodata_value boolean,	bins int,	right boolean,	OUT min double precision,	OUT max double precision,	OUT count bigint,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram (	rast raster, nband int,	bins int, width double precision[] ,	right boolean ,	OUT min double precision,	OUT max double precision,	OUT count bigint,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram (	rast raster, nband int,	bins int,	right boolean,	OUT min double precision,	OUT max double precision,	OUT count bigint,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram (	rast raster, nband int ,	exclude_nodata_value boolean ,	sample_percent double precision ,	bins int , width double precision[] ,	right boolean ,	OUT min double precision,	OUT max double precision,	OUT count bigint,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram (	rast raster, nband int,	exclude_nodata_value boolean,	sample_percent double precision,	bins int,	right boolean,	OUT min double precision,	OUT max double precision,	OUT count bigint,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram (	rast raster, nband int,	sample_percent double precision,	OUT min double precision,	OUT max double precision,	OUT count bigint,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram (	rast raster,	sample_percent double precision,	OUT min double precision,	OUT max double precision,	OUT count bigint,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram (	rast raster, nband int,	sample_percent double precision,	bins int, width double precision[] ,	right boolean ,	OUT min double precision,	OUT max double precision,	OUT count bigint,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram (	rast raster, nband int,	sample_percent double precision,	bins int, right boolean,	OUT min double precision,	OUT max double precision,	OUT count bigint,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_quantile (	rast raster,	nband int ,	exclude_nodata_value boolean ,	sample_percent double precision ,	quantiles double precision[] ,	OUT quantile double precision,	OUT value double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile (	rast raster,	nband int ,	exclude_nodata_value boolean ,	quantiles double precision[] ,	OUT quantile double precision,	OUT value double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile (	rast raster,	nband int,	quantiles double precision[],	OUT quantile double precision,	OUT value double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile (	rast raster,	quantiles double precision[],	OUT quantile double precision,	OUT value double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile (rast raster, nband int, exclude_nodata_value boolean, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile (rast raster, nband int, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile (rast raster, exclude_nodata_value boolean, quantile double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile (rast raster, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile (	rast raster,	nband int ,	exclude_nodata_value boolean ,	sample_percent double precision ,	quantiles double precision[] ,	OUT quantile double precision,	OUT value double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile (	rast raster,	nband int,	sample_percent double precision,	quantiles double precision[] ,	OUT quantile double precision,	OUT value double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile (	rast raster,	sample_percent double precision,	quantiles double precision[] ,	OUT quantile double precision,	OUT value double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile (	rast raster,	quantiles double precision[],	OUT quantile double precision,	OUT value double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile (rast raster, nband int, exclude_nodata_value boolean, sample_percent double precision, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile (rast raster, nband int, sample_percent double precision, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile (rast raster, sample_percent double precision, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile (rast raster, exclude_nodata_value boolean, quantile double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_valuecount (	rast raster, nband integer ,	exclude_nodata_value boolean ,	searchvalues double precision[] ,	roundto double precision ,	OUT value double precision,	OUT count integer,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount (	rast raster, nband integer ,	exclude_nodata_value boolean ,	searchvalues double precision[] ,	roundto double precision ,	OUT value double precision, OUT count integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount (rast raster, nband integer, searchvalues double precision[], roundto double precision , OUT value double precision, OUT count integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount (rast raster, searchvalues double precision[], roundto double precision , OUT value double precision, OUT count integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount (rast raster, nband integer, exclude_nodata_value boolean, searchvalue double precision, roundto double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount (rast raster, nband integer, searchvalue double precision, roundto double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount (rast raster, searchvalue double precision, roundto double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuepercent (	rast raster, nband integer ,	exclude_nodata_value boolean ,	searchvalues double precision[] ,	roundto double precision ,	OUT value double precision, OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuepercent (rast raster, nband integer, searchvalues double precision[], roundto double precision , OUT value double precision, OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuepercent (rast raster, searchvalues double precision[], roundto double precision , OUT value double precision, OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuepercent (rast raster, nband integer, exclude_nodata_value boolean, searchvalue double precision, roundto double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuepercent (rast raster, nband integer, searchvalue double precision, roundto double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuepercent (rast raster, searchvalue double precision, roundto double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_valuecount (	rastertable text,	rastercolumn text,	nband integer ,	exclude_nodata_value boolean ,	searchvalues double precision[] ,	roundto double precision ,	OUT value double precision,	OUT count integer,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount (	rastertable text, rastercolumn text,	nband integer ,	exclude_nodata_value boolean ,	searchvalues double precision[] ,	roundto double precision ,	OUT value double precision, OUT count integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount (rastertable text, rastercolumn text, nband integer, searchvalues double precision[], roundto double precision , OUT value double precision, OUT count integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount (rastertable text, rastercolumn text, searchvalues double precision[], roundto double precision , OUT value double precision, OUT count integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount (rastertable text, rastercolumn text, nband integer, exclude_nodata_value boolean, searchvalue double precision, roundto double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount (rastertable text, rastercolumn text, nband integer, searchvalue double precision, roundto double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount (rastertable text, rastercolumn text, searchvalue double precision, roundto double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuepercent (	rastertable text, rastercolumn text,	nband integer ,	exclude_nodata_value boolean ,	searchvalues double precision[] ,	roundto double precision ,	OUT value double precision, OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuepercent (rastertable text, rastercolumn text, nband integer, searchvalues double precision[], roundto double precision , OUT value double precision, OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuepercent (rastertable text, rastercolumn text, searchvalues double precision[], roundto double precision , OUT value double precision, OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuepercent (rastertable text, rastercolumn text, nband integer, exclude_nodata_value boolean, searchvalue double precision, roundto double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuepercent (rastertable text, rastercolumn text, nband integer, searchvalue double precision, roundto double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuepercent (rastertable text, rastercolumn text, searchvalue double precision, roundto double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_reclass (rast raster, VARIADIC reclassargset reclassarg[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_ReclassExact (rast raster,	inputvalues float8[], outputvalues float8[],	bandnumber integer ,	outputpixeltype text ,	nodatavalue float8 );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_reclass (rast raster, VARIADIC reclassargset reclassarg[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_reclass (rast raster, nband int, reclassexpr text, pixeltype text, nodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_reclass (rast raster, reclassexpr text, pixeltype text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_colormap (	rast raster, nband int,	colormap text,	method text );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_colormap (	rast raster, nband int ,	colormap text ,	method text );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_colormap (	rast raster,	colormap text,	method text );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_fromgdalraster (gdaldata bytea, srid integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_gdaldrivers (	OUT idx int,	OUT short_name text,	OUT long_name text,	OUT can_read boolean,	OUT can_write boolean,	OUT create_options text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asgdalraster (rast raster, format text, options text[] , srid integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Contour (		rast raster,		bandnumber integer ,		level_interval float8 ,		level_base float8 ,		fixed_levels float8[] ,		polygonize boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_InterpolateRaster (		geom geometry,		options text,		rast raster,		bandnumber integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_astiff (rast raster, options text[] , srid integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_astiff (rast raster, nbands int[], options text[] , srid integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_astiff (rast raster, compression text, srid integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_astiff (rast raster, nbands int[], compression text, srid integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asjpeg (rast raster, options text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asjpeg (rast raster, nbands int[], options text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asjpeg (rast raster, nbands int[], quality int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asjpeg (rast raster, nband int, options text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asjpeg (rast raster, nband int, quality int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_aspng (rast raster, options text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_aspng (rast raster, nbands int[], options text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_aspng (rast raster, nbands int[], compression int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_aspng (rast raster, nband int, options text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_aspng (rast raster, nband int, compression int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_asraster (	geom geometry,	scalex double precision , scaley double precision ,	width integer , height integer ,	pixeltype text[] ,	value double precision[] ,	nodataval double precision[] ,	upperleftx double precision , upperlefty double precision ,	gridx double precision , gridy double precision ,	skewx double precision , skewy double precision ,	touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asraster (	geom geometry,	scalex double precision, scaley double precision,	gridx double precision , gridy double precision ,	pixeltype text[] ,	value double precision[] ,	nodataval double precision[] ,	skewx double precision , skewy double precision ,	touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asraster (	geom geometry,	scalex double precision, scaley double precision,	pixeltype text[],	value double precision[] ,	nodataval double precision[] ,	upperleftx double precision , upperlefty double precision ,	skewx double precision , skewy double precision ,	touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asraster (	geom geometry,	width integer, height integer,	gridx double precision , gridy double precision ,	pixeltype text[] ,	value double precision[] ,	nodataval double precision[] ,	skewx double precision , skewy double precision ,	touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asraster (	geom geometry,	width integer, height integer,	pixeltype text[],	value double precision[] ,	nodataval double precision[] ,	upperleftx double precision , upperlefty double precision ,	skewx double precision , skewy double precision ,	touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asraster (	geom geometry,	scalex double precision, scaley double precision,	gridx double precision, gridy double precision,	pixeltype text,	value double precision ,	nodataval double precision ,	skewx double precision , skewy double precision ,	touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asraster (	geom geometry,	scalex double precision, scaley double precision,	pixeltype text,	value double precision ,	nodataval double precision ,	upperleftx double precision , upperlefty double precision ,	skewx double precision , skewy double precision ,	touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asraster (	geom geometry,	width integer, height integer,	gridx double precision, gridy double precision,	pixeltype text,	value double precision ,	nodataval double precision ,	skewx double precision , skewy double precision ,	touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asraster (	geom geometry,	width integer, height integer,	pixeltype text,	value double precision ,	nodataval double precision ,	upperleftx double precision , upperlefty double precision ,	skewx double precision , skewy double precision ,	touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asraster (	geom geometry,	ref raster,	pixeltype text[] ,	value double precision[] ,	nodataval double precision[] ,	touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asraster (	geom geometry,	ref raster,	pixeltype text,	value double precision ,	nodataval double precision ,	touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _ST_gdalwarp (	rast raster,	algorithm text , maxerr double precision ,	srid integer ,	scalex double precision , scaley double precision ,	gridx double precision , gridy double precision ,	skewx double precision , skewy double precision ,	width integer , height integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_resample (	rast raster,	scalex double precision , scaley double precision ,	gridx double precision , gridy double precision ,	skewx double precision , skewy double precision ,	algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_resample (	rast raster,	width integer, height integer,	gridx double precision , gridy double precision ,	skewx double precision , skewy double precision ,	algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_resample (	rast raster,	ref raster,	algorithm text ,	maxerr double precision ,	usescale boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_resample (	rast raster,	ref raster,	usescale boolean,	algorithm text ,	maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_transform (rast raster, srid integer, algorithm text , maxerr double precision , scalex double precision , scaley double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_transform (rast raster, srid integer, scalex double precision, scaley double precision, algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_transform (rast raster, srid integer, scalexy double precision, algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_transform (	rast raster,	alignto raster,	algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_rescale (rast raster, scalex double precision, scaley double precision, algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_rescale (rast raster, scalexy double precision, algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_reskew (rast raster, skewx double precision, skewy double precision, algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_reskew (rast raster, skewxy double precision, algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_snaptogrid (	rast raster,	gridx double precision, gridy double precision,	algorithm text , maxerr double precision ,	scalex double precision , scaley double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_snaptogrid (	rast raster,	gridx double precision, gridy double precision,	scalex double precision, scaley double precision,	algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_snaptogrid (	rast raster,	gridx double precision, gridy double precision,	scalexy double precision,	algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_resize (	rast raster,	width text, height text,	algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_resize (	rast raster,	width integer, height integer,	algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_resize (	rast raster,	percentwidth double precision, percentheight double precision,	algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebraexpr (rast raster, band integer, pixeltype text,        expression text, nodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebraexpr (rast raster, pixeltype text, expression text,        nodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebrafct (rast raster, band integer,        pixeltype text, onerastuserfunc regprocedure, variadic args text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebrafct (rast raster, band integer,        pixeltype text, onerastuserfunc regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebrafct (rast raster, band integer,        onerastuserfunc regprocedure, variadic args text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebrafct (rast raster, band integer,        onerastuserfunc regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebrafct (rast raster, pixeltype text,        onerastuserfunc regprocedure, variadic args text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebrafct (rast raster, pixeltype text,        onerastuserfunc regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebrafct (rast raster, onerastuserfunc regprocedure,        variadic args text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebrafct (rast raster, onerastuserfunc regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebraexpr (	rast1 raster, band1 integer,	rast2 raster, band2 integer,	expression text,	pixeltype text , extenttype text ,	nodata1expr text , nodata2expr text ,	nodatanodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebraexpr (	rast1 raster,	rast2 raster,	expression text,	pixeltype text , extenttype text ,	nodata1expr text , nodata2expr text ,	nodatanodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebrafct (	rast1 raster, band1 integer,	rast2 raster, band2 integer,	tworastuserfunc regprocedure,	pixeltype text , extenttype text ,	VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebrafct (	rast1 raster,	rast2 raster,	tworastuserfunc regprocedure,	pixeltype text ,	extenttype text ,	VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebrafctngb (    rast raster,    band integer,    pixeltype text,    ngbwidth integer,    ngbheight integer,    onerastngbuserfunc regprocedure,    nodatamode text,    variadic args text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_max4ma (matrix float[][], nodatamode text, variadic args text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_min4ma (matrix float[][], nodatamode text, variadic args text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_sum4ma (matrix float[][], nodatamode text, variadic args text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mean4ma (matrix float[][], nodatamode text, variadic args text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_range4ma (matrix float[][], nodatamode text, variadic args text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_distinct4ma (matrix float[][], nodatamode TEXT, VARIADIC args TEXT[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_stddev4ma (matrix float[][], nodatamode TEXT, VARIADIC args TEXT[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_mapalgebra (	rastbandargset rastbandarg[],	callbackfunc regprocedure,	pixeltype text ,	distancex integer , distancey integer ,	extenttype text , customextent raster ,	mask double precision[][] , weighted boolean ,	VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebra (	rastbandargset rastbandarg[],	callbackfunc regprocedure,	pixeltype text ,	extenttype text , customextent raster ,	distancex integer , distancey integer ,	VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebra (	rast raster, nband int[],	callbackfunc regprocedure,	pixeltype text ,	extenttype text , customextent raster ,	distancex integer , distancey integer ,	VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebra (	rast raster, nband int,	callbackfunc regprocedure,	pixeltype text ,	extenttype text , customextent raster ,	distancex integer , distancey integer ,	VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebra (	rast1 raster, nband1 int,	rast2 raster, nband2 int,	callbackfunc regprocedure,	pixeltype text ,	extenttype text , customextent raster ,	distancex integer , distancey integer ,	VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebra (	rast raster, nband int,	callbackfunc regprocedure,	mask double precision [][], weighted boolean,	pixeltype text ,	extenttype text , customextent raster ,	VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_mapalgebra (	rastbandargset rastbandarg[],	expression text,	pixeltype text , extenttype text ,	nodata1expr text , nodata2expr text ,	nodatanodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebra (	rast raster, nband integer,	pixeltype text,	expression text, nodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebra (	rast raster,	pixeltype text,	expression text, nodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebra (	rast1 raster, band1 integer,	rast2 raster, band2 integer,	expression text,	pixeltype text , extenttype text ,	nodata1expr text , nodata2expr text ,	nodatanodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebra (	rast1 raster,	rast2 raster,	expression text,	pixeltype text , extenttype text ,	nodata1expr text , nodata2expr text ,	nodatanodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_convertarray4ma (value double precision[][]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_max4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_min4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_sum4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mean4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_range4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_distinct4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_stddev4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_invdistweight4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mindist4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_slope4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_slope (	rast raster,	nband integer,	customextent raster,	pixeltype text ,	units text ,	scale double precision ,	interpolate_nodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_slope (	rast raster,	nband integer ,	pixeltype text ,	units text ,	scale double precision ,	interpolate_nodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_aspect4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_aspect (	rast raster,	nband integer,	customextent raster,	pixeltype text ,	units text ,	interpolate_nodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_aspect (	rast raster,	nband integer ,	pixeltype text ,	units text ,	interpolate_nodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_hillshade4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_hillshade (	rast raster, nband integer,	customextent raster,	pixeltype text ,	azimuth double precision , altitude double precision ,	max_bright double precision , scale double precision ,	interpolate_nodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_hillshade (	rast raster, nband integer ,	pixeltype text ,	azimuth double precision , altitude double precision ,	max_bright double precision , scale double precision ,	interpolate_nodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_tpi4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_tpi (	rast raster, nband integer,	customextent raster,	pixeltype text , interpolate_nodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_tpi (	rast raster, nband integer ,	pixeltype text , interpolate_nodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_roughness4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_roughness (	rast raster, nband integer,	customextent raster,	pixeltype text , interpolate_nodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_roughness (	rast raster, nband integer ,	pixeltype text , interpolate_nodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_tri4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_tri (	rast raster, nband integer,	customextent raster,	pixeltype text ,	interpolate_nodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_tri (	rast raster, nband integer ,	pixeltype text , interpolate_nodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_grayscale4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_grayscale (	rastbandargset rastbandarg[],	extenttype text );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_grayscale (	rast raster, 	redband integer , 	greenband integer , 	blueband integer ,	extenttype text );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_isempty (rast raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_hasnoband (rast raster, nband int );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandnodatavalue (rast raster, band integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandisnodata (rast raster, band integer , forceChecking boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandisnodata (rast raster, forceChecking boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandpath (rast raster, band integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_BandPixelType (rast raster, band integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_BandMetaData (	rast raster,	band int[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_BandMetaData (	rast raster,	band int );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_BandFileSize (rast raster, band integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION St_BandFileTimestamp (rast raster, band integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value (rast raster, band integer, x integer, y integer, exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value (rast raster, band integer, pt geometry, exclude_nodata_value boolean , resample text );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value (rast raster, x integer, y integer, exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value (rast raster, pt geometry, exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setz (rast raster, geom geometry, resample text , band integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setm (rast raster, geom geometry, resample text , band integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_pixelofvalue (	rast raster,	nband integer,	search double precision[],	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_PixelofValue (	rast raster,	search double precision[],	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_pixelofvalue (	rast raster,	nband integer,	search double precision,	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_pixelofvalue (	rast raster,	search double precision,	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_georeference (rast raster, format text );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setscale (rast raster, scale float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setscale (rast raster, scalex float8, scaley float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setskew (rast raster, skew float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setskew (rast raster, skewx float8, skewy float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setsrid (rast raster, srid integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setupperleft (rast raster, upperleftx float8, upperlefty float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setrotation (rast raster, rotation float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setgeotransform (rast raster,    imag double precision,    jmag double precision,    theta_i double precision,    theta_ij double precision,    xoffset double precision,    yoffset double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setgeoreference (rast raster, georef text, format text );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setgeoreference (	rast raster,	upperleftx double precision, upperlefty double precision,	scalex double precision, scaley double precision,	skewx double precision, skewy double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_tile (	rast raster,	width integer, height integer,	nband integer[] ,	padwithnodata boolean , nodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_tile (	rast raster, nband integer[],	width integer, height integer,	padwithnodata boolean , nodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_tile (	rast raster, nband integer,	width integer, height integer,	padwithnodata boolean , nodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_tile (	rast raster,	width integer, height integer,	padwithnodata boolean , nodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setbandnodatavalue (rast raster, band integer, nodatavalue float8, forceChecking boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setbandnodatavalue (rast raster, nodatavalue float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setbandisnodata (rast raster, band integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setbandpath (rast raster, band integer, outdbpath text, outdbindex integer, force boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setbandindex (rast raster, band integer, outdbindex integer, force boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _ST_SetValues (	rast raster, nband integer,	x integer, y integer,	newvalueset double precision[][],	noset boolean[][] ,	hasnosetvalue boolean ,	nosetvalue double precision ,	keepnodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_SetValues (	rast raster, nband integer,	x integer, y integer,	newvalueset double precision[][],	noset boolean[][] ,	keepnodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_SetValues (	rast raster, nband integer,	x integer, y integer,	newvalueset double precision[][],	nosetvalue double precision,	keepnodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_SetValues (	rast raster, nband integer,	x integer, y integer,	width integer, height integer,	newvalue double precision,	keepnodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_SetValues (	rast raster,	x integer, y integer,	width integer, height integer,	newvalue double precision,	keepnodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_SetValues (	rast raster, nband integer,	geomvalset geomval[],	keepnodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_SetValue (rast raster, band integer, x integer, y integer, newvalue float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_SetValue (rast raster, x integer, y integer, newvalue float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_SetValue (	rast raster, nband integer,	geom geometry, newvalue double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_SetValue (	rast raster,	geom geometry, newvalue double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_dumpaspolygons (rast raster, band integer , exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_dumpvalues (	rast raster, nband integer[] , exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_dumpvalues (rast raster, nband integer, exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_polygon (rast raster, band integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_pixelaspolygons (	rast raster,	band integer ,	columnx integer ,	rowy integer ,	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_pixelaspolygons (	rast raster,	band integer ,	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_pixelaspolygon (rast raster, x integer, y integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_pixelaspoints (	rast raster,	band integer ,	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_pixelaspoint (rast raster, x integer, y integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_pixelascentroids (	rast raster,	band integer ,	columnx integer ,	rowy integer ,	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_pixelascentroids (	rast raster,	band integer ,	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_pixelascentroid (rast raster, x integer, y integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_worldtorastercoord (	rast raster,	longitude double precision , latitude double precision ,	OUT columnx integer,	OUT rowy integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_worldtorastercoord (	rast raster,	longitude double precision, latitude double precision,	OUT columnx integer,	OUT rowy integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_worldtorastercoord (	rast raster, pt geometry,	OUT columnx integer,	OUT rowy integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_worldtorastercoordx (rast raster, xw float8, yw float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_worldtorastercoordx (rast raster, xw float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_worldtorastercoordx (rast raster, pt geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_worldtorastercoordy (rast raster, xw float8, yw float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_worldtorastercoordy (rast raster, yw float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_worldtorastercoordy (rast raster, pt geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_rastertoworldcoord (	rast raster,	columnx integer , rowy integer ,	OUT longitude double precision,	OUT latitude double precision	);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_rastertoworldcoord (	rast raster,	columnx integer, rowy integer,	OUT	longitude double precision,	OUT latitude double precision	);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_rastertoworldcoordx (rast raster, xr int, yr int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_rastertoworldcoordx (rast raster, xr int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_rastertoworldcoordy (rast raster, xr int, yr int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_rastertoworldcoordy (rast raster, yr int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_minpossiblevalue (pixeltype text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_rastfromwkb (bytea);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_rastfromhexwkb (text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_aswkb (raster, outasin boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asbinary (raster, outasin boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_ashexwkb (raster, outasin boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION bytea (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION raster_hash (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION raster_eq (raster, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION raster_overleft (raster, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION raster_overright (raster, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION raster_left (raster, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION raster_right (raster, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION raster_overabove (raster, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION raster_overbelow (raster, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION raster_above (raster, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION raster_below (raster, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION raster_same (raster, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION raster_contained (raster, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION raster_contain (raster, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION raster_overlap (raster, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION raster_geometry_contain (raster, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION raster_contained_by_geometry (raster, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION raster_geometry_overlap (raster, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION geometry_raster_contain (geometry, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION geometry_contained_by_raster (geometry, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION geometry_raster_overlap (geometry, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_samealignment (rast1 raster, rast2 raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_samealignment (	ulx1 double precision, uly1 double precision, scalex1 double precision, scaley1 double precision, skewx1 double precision, skewy1 double precision,	ulx2 double precision, uly2 double precision, scalex2 double precision, scaley2 double precision, skewx2 double precision, skewy2 double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_samealignment_transfn (agg agg_samealignment, rast raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _ST_samealignment_finalfn (agg agg_samealignment);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_notsamealignmentreason (rast1 raster, rast2 raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_iscoveragetile (rast raster, coverage raster, tilewidth integer, tileheight integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_intersects (rast1 raster, nband1 integer, rast2 raster, nband2 integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersects (rast1 raster, nband1 integer, rast2 raster, nband2 integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersects (rast1 raster, rast2 raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_intersects (geom geometry, rast raster, nband integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersects (geom geometry, rast raster, nband integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersects (rast raster, geom geometry, nband integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersects (rast raster, nband integer, geom geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_overlaps (rast1 raster, nband1 integer, rast2 raster, nband2 integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_overlaps (rast1 raster, nband1 integer, rast2 raster, nband2 integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_overlaps (rast1 raster, rast2 raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_touches (rast1 raster, nband1 integer, rast2 raster, nband2 integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_touches (rast1 raster, nband1 integer, rast2 raster, nband2 integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_touches (rast1 raster, rast2 raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_contains (rast1 raster, nband1 integer, rast2 raster, nband2 integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_contains (rast1 raster, nband1 integer, rast2 raster, nband2 integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_contains (rast1 raster, rast2 raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_containsproperly (rast1 raster, nband1 integer, rast2 raster, nband2 integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_containsproperly (rast1 raster, nband1 integer, rast2 raster, nband2 integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_containsproperly (rast1 raster, rast2 raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_covers (rast1 raster, nband1 integer, rast2 raster, nband2 integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_covers (rast1 raster, nband1 integer, rast2 raster, nband2 integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_covers (rast1 raster, rast2 raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_coveredby (rast1 raster, nband1 integer, rast2 raster, nband2 integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_coveredby (rast1 raster, nband1 integer, rast2 raster, nband2 integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_coveredby (rast1 raster, rast2 raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_within (rast1 raster, nband1 integer, rast2 raster, nband2 integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_within (rast1 raster, nband1 integer, rast2 raster, nband2 integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_within (rast1 raster, rast2 raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _ST_DWithin (rast1 raster, nband1 integer, rast2 raster, nband2 integer, distance double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_DWithin (rast1 raster, nband1 integer, rast2 raster, nband2 integer, distance double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_DWithin (rast1 raster, rast2 raster, distance double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _ST_DFullyWithin (rast1 raster, nband1 integer, rast2 raster, nband2 integer, distance double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_DFullyWithin (rast1 raster, nband1 integer, rast2 raster, nband2 integer, distance double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_DFullyWithin (rast1 raster, rast2 raster, distance double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_disjoint (rast1 raster, nband1 integer, rast2 raster, nband2 integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Disjoint (rast1 raster, rast2 raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_IntersectionFractions (rast raster, geom geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Intersection (geomin geometry, rast raster, band integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection (rast raster, band integer, geomin geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Intersection (rast raster, geomin geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Intersection (	rast1 raster, band1 int,	rast2 raster, band2 int,	returnband text ,	nodataval double precision[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection (	rast1 raster, band1 int,	rast2 raster, band2 int,	returnband text,	nodataval double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection (	rast1 raster, band1 int,	rast2 raster, band2 int,	nodataval double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection (	rast1 raster, band1 int,	rast2 raster, band2 int,	nodataval double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection (	rast1 raster,	rast2 raster,	returnband text ,	nodataval double precision[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection (	rast1 raster,	rast2 raster,	returnband text,	nodataval double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection (	rast1 raster,	rast2 raster,	nodataval double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection (	rast1 raster,	rast2 raster,	nodataval double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_union_finalfn (internal);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_union_transfn (internal, raster, unionarg[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_union_transfn (internal, raster, integer, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_union_transfn (internal, raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_union_transfn (internal, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_union_transfn (internal, raster, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _ST_AsRasterAgg_transfn (staterast raster, geom geometry, val float8, rast raster, pixeltype text, nodataval float8, uniontype text, touched boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _ST_AsRasterAgg_finalfn (rast raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_clip (	rast raster, nband integer[],	geom geometry,	nodataval float8[] , crop boolean , touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_clip (	rast raster,	nband integer[],	geom geometry,	nodataval float8[],	crop boolean , touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_clip (	rast raster, nband integer,	geom geometry,	nodataval float8, crop boolean , touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_clip (	rast raster,	nband integer,	geom geometry,	crop boolean , touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_clip (	rast raster,	geom geometry,	nodataval float8[] , crop boolean , touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_clip (	rast raster,	geom geometry,	nodataval double precision, crop boolean , touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_clip (	rast raster,	geom geometry,	crop boolean, touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_nearestvalue (	rast raster, band integer,	pt geometry,	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_nearestvalue (	rast raster,	pt geometry,	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_nearestvalue (	rast raster, band integer,	columnx integer, rowy integer,	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_nearestvalue (	rast raster,	columnx integer, rowy integer,	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_neighborhood (	rast raster, band integer,	columnx integer, rowy integer,	distancex integer, distancey integer,	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_neighborhood (	rast raster, band integer,	columnx integer, rowy integer,	distancex integer, distancey integer,	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_neighborhood (	rast raster,	columnx integer, rowy integer,	distancex integer, distancey integer,	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_neighborhood (	rast raster, band integer,	pt geometry,	distancex integer, distancey integer,	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_neighborhood (	rast raster,	pt geometry,	distancex integer, distancey integer,	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _add_raster_constraint (cn name, sql text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _drop_raster_constraint (rastschema name, rasttable name, cn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _raster_constraint_info_srid (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _add_raster_constraint_srid (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _drop_raster_constraint_srid (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _raster_constraint_info_scale (rastschema name, rasttable name, rastcolumn name, axis char);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _add_raster_constraint_scale (rastschema name, rasttable name, rastcolumn name, axis char);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _drop_raster_constraint_scale (rastschema name, rasttable name, rastcolumn name, axis char);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _raster_constraint_info_blocksize (rastschema name, rasttable name, rastcolumn name, axis text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _add_raster_constraint_blocksize (rastschema name, rasttable name, rastcolumn name, axis text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _drop_raster_constraint_blocksize (rastschema name, rasttable name, rastcolumn name, axis text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _raster_constraint_info_extent (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _add_raster_constraint_extent (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _drop_raster_constraint_extent (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _raster_constraint_info_alignment (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _add_raster_constraint_alignment (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _drop_raster_constraint_alignment (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _raster_constraint_info_spatially_unique (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _add_raster_constraint_spatially_unique (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _drop_raster_constraint_spatially_unique (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _raster_constraint_info_coverage_tile (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _add_raster_constraint_coverage_tile (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _drop_raster_constraint_coverage_tile (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _raster_constraint_info_regular_blocking (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _drop_raster_constraint_regular_blocking (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _raster_constraint_info_num_bands (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _add_raster_constraint_num_bands (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _drop_raster_constraint_num_bands (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _raster_constraint_info_pixel_types (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _raster_constraint_pixel_types (rast raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _add_raster_constraint_pixel_types (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _drop_raster_constraint_pixel_types (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _raster_constraint_info_nodata_values (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _raster_constraint_nodata_values (rast raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _add_raster_constraint_nodata_values (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _drop_raster_constraint_nodata_values (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _raster_constraint_info_out_db (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _raster_constraint_out_db (rast raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _add_raster_constraint_out_db (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _drop_raster_constraint_out_db (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _raster_constraint_info_index (rastschema name, rasttable name, rastcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION AddRasterConstraints  (	rastschema name,	rasttable name,	rastcolumn name,	VARIADIC constraints text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION AddRasterConstraints  (	rasttable name,	rastcolumn name,	VARIADIC constraints text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION AddRasterConstraints  (	rastschema name,	rasttable name,	rastcolumn name,	srid boolean ,	scale_x boolean ,	scale_y boolean ,	blocksize_x boolean ,	blocksize_y boolean ,	same_alignment boolean ,	regular_blocking boolean , 	num_bands boolean ,	pixel_types boolean ,	nodata_values boolean ,	out_db boolean ,	extent boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION AddRasterConstraints  (	rasttable name,	rastcolumn name,	srid boolean ,	scale_x boolean ,	scale_y boolean ,	blocksize_x boolean ,	blocksize_y boolean ,	same_alignment boolean ,	regular_blocking boolean , 	num_bands boolean ,	pixel_types boolean ,	nodata_values boolean ,	out_db boolean ,	extent boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION DropRasterConstraints  (	rastschema name,	rasttable name,	rastcolumn name,	VARIADIC constraints text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION DropRasterConstraints  (	rasttable name,	rastcolumn name,	VARIADIC constraints text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION DropRasterConstraints  (	rastschema name,	rasttable name,	rastcolumn name,	srid boolean ,	scale_x boolean ,	scale_y boolean ,	blocksize_x boolean ,	blocksize_y boolean ,	same_alignment boolean ,	regular_blocking boolean ,	num_bands boolean ,	pixel_types boolean ,	nodata_values boolean ,	out_db boolean ,	extent boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION DropRasterConstraints  (	rasttable name,	rastcolumn name,	srid boolean ,	scale_x boolean ,	scale_y boolean ,	blocksize_x boolean ,	blocksize_y boolean ,	same_alignment boolean ,	regular_blocking boolean ,	num_bands boolean ,	pixel_types boolean ,	nodata_values boolean ,	out_db boolean ,	extent boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _overview_constraint (ov raster, factor integer, refschema name, reftable name, refcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _overview_constraint_info (	ovschema name, ovtable name, ovcolumn name,		OUT refschema name,		OUT reftable name,		OUT refcolumn name,		OUT factor integer	);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _add_overview_constraint (	ovschema name, ovtable name, ovcolumn name,	refschema name, reftable name, refcolumn name,	factor integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _drop_overview_constraint (ovschema name, ovtable name, ovcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION AddOverviewConstraints  (	ovschema name, ovtable name, ovcolumn name,	refschema name, reftable name, refcolumn name,	ovfactor int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION AddOverviewConstraints  (	ovtable name, ovcolumn name,	reftable name, refcolumn name,	ovfactor int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION DropOverviewConstraints  (	ovschema name,	ovtable name,	ovcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION DropOverviewConstraints  (	ovtable name,	ovcolumn name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _UpdateRasterSRID (	schema_name name, table_name name, column_name name,	new_srid integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION UpdateRasterSRID (	schema_name name, table_name name, column_name name,	new_srid integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION UpdateRasterSRID (	table_name name, column_name name,	new_srid integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Retile (tab regclass, col name, ext geometry, sfx float8, sfy float8, tw int, th int, algo text );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_CreateOverview (tab regclass, col name, factor int, algo text );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_makeemptycoverage (tilewidth int, tileheight int, width int, height int, upperleftx float8, upperlefty float8, scalex float8, scaley float8, skewx float8, skewy float8, srid integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION postgis_noop (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP TYPE raster;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP TYPE rastbandarg;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP TYPE geomval;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP TYPE addbandarg;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP TYPE summarystats;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP TYPE agg_count;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP TYPE reclassarg;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP TYPE agg_samealignment;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP TYPE unionarg;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION raster_in (cstring);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION raster_out (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
		$unpackage$;

		RAISE WARNING 'PostGIS Raster functionality has been unpackaged'
		USING HINT = 'type `SELECT postgis_extensions_upgrade();` to finish the upgrade.'
						' After upgrading, if you want to drop raster, run: DROP EXTENSION postgis_raster;';
	END IF;
END
$unpackage_if_needed$ LANGUAGE 'plpgsql';

