-- gnomo
ALTER FUNCTION gnomonic_proj(spoint, spoint) PARALLEL SAFE;
ALTER FUNCTION gnomonic_inv(point, spoint) PARALLEL SAFE;

-- sbox
ALTER FUNCTION sbox(spoint, spoint) PARALLEL SAFE;
ALTER FUNCTION sw(sbox) PARALLEL SAFE;
ALTER FUNCTION se(sbox) PARALLEL SAFE;
ALTER FUNCTION nw(sbox) PARALLEL SAFE;
ALTER FUNCTION ne(sbox) PARALLEL SAFE;
ALTER FUNCTION area(sbox) PARALLEL SAFE;
ALTER FUNCTION circum(sbox) PARALLEL SAFE;
ALTER FUNCTION sbox_equal(sbox, sbox) PARALLEL SAFE;
ALTER FUNCTION sbox_equal_neg(sbox, sbox) PARALLEL SAFE;
ALTER FUNCTION sbox_contains_box(sbox, sbox) PARALLEL SAFE;
ALTER FUNCTION sbox_contains_box_com(sbox, sbox) PARALLEL SAFE;
ALTER FUNCTION sbox_contains_box_neg(sbox, sbox) PARALLEL SAFE;
ALTER FUNCTION sbox_contains_box_com_neg(sbox, sbox) PARALLEL SAFE;
ALTER FUNCTION sbox_overlap_box(sbox, sbox) PARALLEL SAFE;
ALTER FUNCTION sbox_overlap_box_neg(sbox, sbox) PARALLEL SAFE;
ALTER FUNCTION sbox_cont_point_com(spoint, sbox) PARALLEL SAFE;
ALTER FUNCTION sbox_cont_point_com_neg(spoint, sbox) PARALLEL SAFE;
ALTER FUNCTION sbox_cont_point(sbox, spoint) PARALLEL SAFE;
ALTER FUNCTION sbox_cont_point_neg(sbox, spoint) PARALLEL SAFE;
ALTER FUNCTION sbox_contains_circle(sbox, scircle) PARALLEL SAFE;
ALTER FUNCTION sbox_contains_circle_com(scircle, sbox) PARALLEL SAFE;
ALTER FUNCTION sbox_contains_circle_neg(sbox, scircle) PARALLEL SAFE;
ALTER FUNCTION sbox_contains_circle_com_neg(scircle, sbox) PARALLEL SAFE;
ALTER FUNCTION sbox_overlap_circle(sbox, scircle) PARALLEL SAFE;
ALTER FUNCTION sbox_overlap_circle_com(scircle, sbox) PARALLEL SAFE;
ALTER FUNCTION sbox_overlap_circle_neg(sbox, scircle) PARALLEL SAFE;
ALTER FUNCTION sbox_overlap_circle_com_neg(scircle, sbox) PARALLEL SAFE;
ALTER FUNCTION sbox_contains_line(sbox, sline) PARALLEL SAFE;
ALTER FUNCTION sbox_contains_line_com(sline, sbox) PARALLEL SAFE;
ALTER FUNCTION sbox_contains_line_neg(sbox, sline) PARALLEL SAFE;
ALTER FUNCTION sbox_contains_line_com_neg(sline, sbox) PARALLEL SAFE;
ALTER FUNCTION sbox_overlap_line(sbox, sline) PARALLEL SAFE;
ALTER FUNCTION sbox_overlap_line_com(sline, sbox) PARALLEL SAFE;
ALTER FUNCTION sbox_overlap_line_neg(sbox, sline) PARALLEL SAFE;
ALTER FUNCTION sbox_overlap_line_com_neg(sline, sbox) PARALLEL SAFE;
ALTER FUNCTION sbox_contains_ellipse(sbox, sellipse) PARALLEL SAFE;
ALTER FUNCTION sbox_contains_ellipse_com(sellipse, sbox) PARALLEL SAFE;
ALTER FUNCTION sbox_contains_ellipse_neg(sbox, sellipse) PARALLEL SAFE;
ALTER FUNCTION sbox_contains_ellipse_com_neg(sellipse, sbox) PARALLEL SAFE;
ALTER FUNCTION sbox_overlap_ellipse(sbox, sellipse) PARALLEL SAFE;
ALTER FUNCTION sbox_overlap_ellipse_com(sellipse, sbox) PARALLEL SAFE;
ALTER FUNCTION sbox_overlap_ellipse_neg(sbox, sellipse) PARALLEL SAFE;
ALTER FUNCTION sbox_overlap_ellipse_com_neg(sellipse, sbox) PARALLEL SAFE;
ALTER FUNCTION sbox_contains_poly(sbox, spoly) PARALLEL SAFE;
ALTER FUNCTION sbox_contains_poly_com(spoly, sbox) PARALLEL SAFE;
ALTER FUNCTION sbox_contains_poly_neg(sbox, spoly) PARALLEL SAFE;
ALTER FUNCTION sbox_contains_poly_com_neg(spoly, sbox) PARALLEL SAFE;
ALTER FUNCTION sbox_overlap_poly(sbox, spoly) PARALLEL SAFE;
ALTER FUNCTION sbox_overlap_poly_com(spoly, sbox) PARALLEL SAFE;
ALTER FUNCTION sbox_overlap_poly_neg(sbox, spoly) PARALLEL SAFE;
ALTER FUNCTION sbox_overlap_poly_com_neg(spoly, sbox) PARALLEL SAFE;
ALTER FUNCTION sbox_contains_path(sbox, spath) PARALLEL SAFE;
ALTER FUNCTION sbox_contains_path_com(spath, sbox) PARALLEL SAFE;
ALTER FUNCTION sbox_contains_path_neg(sbox, spath) PARALLEL SAFE;
ALTER FUNCTION sbox_contains_path_com_neg(spath, sbox) PARALLEL SAFE;
ALTER FUNCTION sbox_overlap_path(sbox, spath) PARALLEL SAFE;
ALTER FUNCTION sbox_overlap_path_com(spath, sbox) PARALLEL SAFE;
ALTER FUNCTION sbox_overlap_path_neg(sbox, spath) PARALLEL SAFE;
ALTER FUNCTION sbox_overlap_path_com_neg(spath, sbox) PARALLEL SAFE;
ALTER FUNCTION scircle_contains_box(scircle, sbox) PARALLEL SAFE;
ALTER FUNCTION scircle_contains_box_com(sbox, scircle) PARALLEL SAFE;
ALTER FUNCTION scircle_contains_box_neg(scircle, sbox) PARALLEL SAFE;
ALTER FUNCTION scircle_contains_box_com_neg(sbox, scircle) PARALLEL SAFE;
ALTER FUNCTION sellipse_contains_box(sellipse, sbox) PARALLEL SAFE;
ALTER FUNCTION sellipse_contains_box_com(sbox, sellipse) PARALLEL SAFE;
ALTER FUNCTION sellipse_contains_box_neg(sellipse, sbox) PARALLEL SAFE;
ALTER FUNCTION sellipse_contains_box_com_neg(sbox, sellipse) PARALLEL SAFE;
ALTER FUNCTION spoly_contains_box(spoly, sbox) PARALLEL SAFE;
ALTER FUNCTION spoly_contains_box_com(sbox, spoly) PARALLEL SAFE;
ALTER FUNCTION spoly_contains_box_neg(spoly, sbox) PARALLEL SAFE;
ALTER FUNCTION spoly_contains_box_com_neg(sbox, spoly) PARALLEL SAFE;

-- scircle
ALTER FUNCTION area(scircle) PARALLEL SAFE;
ALTER FUNCTION radius(scircle) PARALLEL SAFE;
ALTER FUNCTION scircle(spoint, float8) PARALLEL SAFE;
ALTER FUNCTION scircle(spoint) PARALLEL SAFE;
ALTER FUNCTION scircle_equal(scircle, scircle) PARALLEL SAFE;
ALTER FUNCTION scircle_equal_neg(scircle, scircle) PARALLEL SAFE;
ALTER FUNCTION scircle_overlap(scircle, scircle) PARALLEL SAFE;
ALTER FUNCTION scircle_overlap_neg(scircle, scircle) PARALLEL SAFE;
ALTER FUNCTION center(scircle) PARALLEL SAFE;
ALTER FUNCTION circum(scircle) PARALLEL SAFE;
ALTER FUNCTION scircle_contained_by_circle(scircle, scircle) PARALLEL SAFE;
ALTER FUNCTION scircle_contained_by_circle_neg(scircle, scircle) PARALLEL SAFE;
ALTER FUNCTION scircle_contains_circle(scircle, scircle) PARALLEL SAFE;
ALTER FUNCTION scircle_contains_circle_neg(scircle, scircle) PARALLEL SAFE;
ALTER FUNCTION spoint_contained_by_circle(spoint, scircle) PARALLEL SAFE;
ALTER FUNCTION spoint_contained_by_circle_neg(spoint, scircle) PARALLEL SAFE;
ALTER FUNCTION spoint_contained_by_circle_com(scircle, spoint) PARALLEL SAFE;
ALTER FUNCTION spoint_contained_by_circle_com_neg(scircle, spoint) PARALLEL SAFE;
ALTER FUNCTION dist(scircle, scircle) PARALLEL SAFE;
ALTER FUNCTION dist(scircle, spoint) PARALLEL SAFE;
ALTER FUNCTION dist(spoint, scircle) PARALLEL SAFE;
ALTER FUNCTION strans_circle(scircle, strans) PARALLEL SAFE;
ALTER FUNCTION strans_circle_inverse(scircle, strans) PARALLEL SAFE;

-- sellipse 
ALTER FUNCTION sellipse(spoint, float8, float8, float8) PARALLEL SAFE;
ALTER FUNCTION inc(sellipse) PARALLEL SAFE;
ALTER FUNCTION lrad(sellipse) PARALLEL SAFE;
ALTER FUNCTION srad(sellipse) PARALLEL SAFE;
ALTER FUNCTION sellipse(spoint) PARALLEL SAFE;
ALTER FUNCTION scircle(sellipse) PARALLEL SAFE;
ALTER FUNCTION sellipse(scircle) PARALLEL SAFE;
ALTER FUNCTION strans(sellipse) PARALLEL SAFE;
ALTER FUNCTION center(sellipse) PARALLEL SAFE;
ALTER FUNCTION sellipse_equal(sellipse, sellipse) PARALLEL SAFE;
ALTER FUNCTION sellipse_equal_neg(sellipse, sellipse) PARALLEL SAFE;
ALTER FUNCTION sellipse_contains_ellipse(sellipse, sellipse) PARALLEL SAFE;
ALTER FUNCTION sellipse_contains_ellipse_com(sellipse, sellipse) PARALLEL SAFE;
ALTER FUNCTION sellipse_contains_ellipse_neg(sellipse, sellipse) PARALLEL SAFE;
ALTER FUNCTION sellipse_contains_ellipse_com_neg(sellipse, sellipse) PARALLEL SAFE;
ALTER FUNCTION sellipse_overlap_ellipse(sellipse, sellipse) PARALLEL SAFE;
ALTER FUNCTION sellipse_overlap_ellipse_neg(sellipse, sellipse) PARALLEL SAFE;
ALTER FUNCTION sellipse_contains_point(sellipse, spoint) PARALLEL SAFE;
ALTER FUNCTION sellipse_contains_point_com(spoint, sellipse) PARALLEL SAFE;
ALTER FUNCTION sellipse_contains_point_neg(sellipse, spoint) PARALLEL SAFE;
ALTER FUNCTION sellipse_contains_point_com_neg(spoint, sellipse) PARALLEL SAFE;
ALTER FUNCTION strans_ellipse(sellipse, strans) PARALLEL SAFE;
ALTER FUNCTION strans_ellipse_inverse(sellipse, strans) PARALLEL SAFE;
ALTER FUNCTION sellipse_contains_circle(sellipse, scircle) PARALLEL SAFE;
ALTER FUNCTION sellipse_contains_circle_com(scircle, sellipse) PARALLEL SAFE;
ALTER FUNCTION sellipse_contains_circle_neg(sellipse, scircle) PARALLEL SAFE;
ALTER FUNCTION sellipse_contains_circle_com_neg(scircle, sellipse) PARALLEL SAFE;
ALTER FUNCTION scircle_contains_ellipse(scircle, sellipse) PARALLEL SAFE;
ALTER FUNCTION scircle_contains_ellipse_com(sellipse, scircle) PARALLEL SAFE;
ALTER FUNCTION scircle_contains_ellipse_neg(scircle, sellipse) PARALLEL SAFE;
ALTER FUNCTION scircle_contains_ellipse_com_neg(sellipse, scircle) PARALLEL SAFE;
ALTER FUNCTION sellipse_overlap_circle(sellipse, scircle) PARALLEL SAFE;
ALTER FUNCTION sellipse_overlap_circle_com(scircle, sellipse) PARALLEL SAFE;
ALTER FUNCTION sellipse_overlap_circle_neg(sellipse, scircle) PARALLEL SAFE;
ALTER FUNCTION sellipse_overlap_circle_com_neg(scircle, sellipse) PARALLEL SAFE;
ALTER FUNCTION sellipse_overlap_line(sellipse, sline) PARALLEL SAFE;
ALTER FUNCTION sellipse_overlap_line_com(sline, sellipse) PARALLEL SAFE;
ALTER FUNCTION sellipse_overlap_line_neg(sellipse, sline) PARALLEL SAFE;
ALTER FUNCTION sellipse_overlap_line_com_neg(sline, sellipse) PARALLEL SAFE;
ALTER FUNCTION sellipse_contains_line(sellipse, sline) PARALLEL SAFE;
ALTER FUNCTION sellipse_contains_line_com(sline, sellipse) PARALLEL SAFE;
ALTER FUNCTION sellipse_contains_line_neg(sellipse, sline) PARALLEL SAFE;
ALTER FUNCTION sellipse_contains_line_com_neg(sline, sellipse) PARALLEL SAFE;

-- euler
ALTER FUNCTION strans_zxz(strans) PARALLEL SAFE;
ALTER FUNCTION strans(FLOAT8, FLOAT8, FLOAT8) PARALLEL SAFE;
ALTER FUNCTION strans(FLOAT8, FLOAT8, FLOAT8, CSTRING) PARALLEL SAFE;
ALTER FUNCTION phi(strans) PARALLEL SAFE;
ALTER FUNCTION theta(strans) PARALLEL SAFE;
ALTER FUNCTION psi(strans) PARALLEL SAFE;
ALTER FUNCTION axes(strans) PARALLEL SAFE;
ALTER FUNCTION strans_equal(strans, strans) PARALLEL SAFE;
ALTER FUNCTION strans_not_equal(strans, strans) PARALLEL SAFE;
ALTER FUNCTION strans(strans) PARALLEL SAFE;
ALTER FUNCTION strans_invert(strans) PARALLEL SAFE;
ALTER FUNCTION strans_point(spoint, strans) PARALLEL SAFE;
ALTER FUNCTION strans_point_inverse(spoint, strans) PARALLEL SAFE;
ALTER FUNCTION strans_trans(strans, strans) PARALLEL SAFE;
ALTER FUNCTION strans_trans_inv(strans, strans) PARALLEL SAFE;

-- gist
ALTER FUNCTION pointkey_volume(pointkey) PARALLEL SAFE;
ALTER FUNCTION pointkey_area(pointkey) PARALLEL SAFE;
ALTER FUNCTION pointkey_perimeter(pointkey) PARALLEL SAFE;

-- sline 
ALTER FUNCTION sline(spoint, spoint) PARALLEL SAFE;
ALTER FUNCTION sline(strans, float8) PARALLEL SAFE;
ALTER FUNCTION meridian(float8) PARALLEL SAFE;
ALTER FUNCTION sl_beg(sline) PARALLEL SAFE;
ALTER FUNCTION sl_end(sline) PARALLEL SAFE;
ALTER FUNCTION strans(sline) PARALLEL SAFE;
ALTER FUNCTION sline(spoint) PARALLEL SAFE;
ALTER FUNCTION sline_equal(sline, sline) PARALLEL SAFE;
ALTER FUNCTION sline_equal_neg(sline, sline) PARALLEL SAFE;
ALTER FUNCTION length(sline) PARALLEL SAFE;
ALTER FUNCTION swap(sline) PARALLEL SAFE;
ALTER FUNCTION turn(sline) PARALLEL SAFE;
ALTER FUNCTION sline_crosses(sline, sline) PARALLEL SAFE;
ALTER FUNCTION sline_crosses_neg(sline, sline) PARALLEL SAFE;
ALTER FUNCTION sline_overlap(sline, sline) PARALLEL SAFE;
ALTER FUNCTION sline_overlap_neg(sline, sline) PARALLEL SAFE;
ALTER FUNCTION sline_contains_point(sline, spoint) PARALLEL SAFE;
ALTER FUNCTION sline_contains_point_com(spoint, sline) PARALLEL SAFE;
ALTER FUNCTION sline_contains_point_neg(sline, spoint) PARALLEL SAFE;
ALTER FUNCTION sline_contains_point_com_neg(spoint, sline) PARALLEL SAFE;
ALTER FUNCTION strans_line(sline, strans) PARALLEL SAFE;
ALTER FUNCTION strans_line_inverse(sline, strans) PARALLEL SAFE;
ALTER FUNCTION sline_overlap_circle(sline, scircle) PARALLEL SAFE;
ALTER FUNCTION sline_overlap_circle_com(scircle, sline) PARALLEL SAFE;
ALTER FUNCTION sline_overlap_circle_neg(sline, scircle) PARALLEL SAFE;
ALTER FUNCTION sline_overlap_circle_com_neg(scircle, sline) PARALLEL SAFE;
ALTER FUNCTION scircle_contains_line(scircle, sline) PARALLEL SAFE;
ALTER FUNCTION scircle_contains_line_com(sline, scircle) PARALLEL SAFE;
ALTER FUNCTION scircle_contains_line_neg(scircle, sline) PARALLEL SAFE;
ALTER FUNCTION scircle_contains_line_com_neg(sline, scircle) PARALLEL SAFE;

-- spath
ALTER FUNCTION npoints(spath) PARALLEL SAFE;
ALTER FUNCTION spoint(spath, int4) PARALLEL SAFE;
ALTER FUNCTION spoint(spath, float8) PARALLEL SAFE;
ALTER FUNCTION spath_equal(spath, spath) PARALLEL SAFE;
ALTER FUNCTION spath_equal_neg(spath, spath) PARALLEL SAFE;
ALTER FUNCTION length(spath) PARALLEL SAFE;
ALTER FUNCTION swap(spath) PARALLEL SAFE;
ALTER FUNCTION spath_overlap_path(spath, spath) PARALLEL SAFE;
ALTER FUNCTION spath_overlap_path_neg(spath, spath) PARALLEL SAFE;
ALTER FUNCTION spath_contains_point(spath, spoint) PARALLEL SAFE;
ALTER FUNCTION spath_contains_point_com(spoint, spath) PARALLEL SAFE;
ALTER FUNCTION spath_contains_point_neg(spath, spoint) PARALLEL SAFE;
ALTER FUNCTION spath_contains_point_com_neg(spoint, spath) PARALLEL SAFE;
ALTER FUNCTION strans_path(spath, strans) PARALLEL SAFE;
ALTER FUNCTION strans_path_inverse(spath, strans) PARALLEL SAFE;
ALTER FUNCTION scircle_contains_path(scircle, spath) PARALLEL SAFE;
ALTER FUNCTION scircle_contains_path_com(spath, scircle) PARALLEL SAFE;
ALTER FUNCTION scircle_contains_path_neg(scircle, spath) PARALLEL SAFE;
ALTER FUNCTION scircle_contains_path_com_neg(spath, scircle) PARALLEL SAFE;
ALTER FUNCTION scircle_overlap_path(scircle, spath) PARALLEL SAFE;
ALTER FUNCTION scircle_overlap_path_com(spath, scircle) PARALLEL SAFE;
ALTER FUNCTION scircle_overlap_path_neg(scircle, spath) PARALLEL SAFE;
ALTER FUNCTION scircle_overlap_path_com_neg(spath, scircle) PARALLEL SAFE;
ALTER FUNCTION spath_overlap_line(spath, sline) PARALLEL SAFE;
ALTER FUNCTION spath_overlap_line_com(sline, spath) PARALLEL SAFE;
ALTER FUNCTION spath_overlap_line_neg(spath, sline) PARALLEL SAFE;
ALTER FUNCTION spath_overlap_line_com_neg(sline, spath) PARALLEL SAFE;
ALTER FUNCTION sellipse_contains_path(sellipse, spath) PARALLEL SAFE;
ALTER FUNCTION sellipse_contains_path_com(spath, sellipse) PARALLEL SAFE;
ALTER FUNCTION sellipse_contains_path_neg(sellipse, spath) PARALLEL SAFE;
ALTER FUNCTION sellipse_contains_path_com_neg(spath, sellipse) PARALLEL SAFE;
ALTER FUNCTION sellipse_overlap_path(sellipse, spath) PARALLEL SAFE;
ALTER FUNCTION sellipse_overlap_path_com(spath, sellipse) PARALLEL SAFE;
ALTER FUNCTION sellipse_overlap_path_neg(sellipse, spath) PARALLEL SAFE;
ALTER FUNCTION sellipse_overlap_path_com_neg(spath, sellipse) PARALLEL SAFE;
ALTER FUNCTION spoly_contains_path(spoly, spath) PARALLEL SAFE;
ALTER FUNCTION spoly_contains_path_com(spath, spoly) PARALLEL SAFE;
ALTER FUNCTION spoly_contains_path_neg(spoly, spath) PARALLEL SAFE;
ALTER FUNCTION spoly_contains_path_com_neg(spath, spoly) PARALLEL SAFE;
ALTER FUNCTION spoly_overlap_path(spoly, spath) PARALLEL SAFE;
ALTER FUNCTION spoly_overlap_path_com(spath, spoly) PARALLEL SAFE;
ALTER FUNCTION spoly_overlap_path_neg(spoly, spath) PARALLEL SAFE;
ALTER FUNCTION spoly_overlap_path_com_neg(spath, spoly) PARALLEL SAFE;
ALTER FUNCTION spath_add_point_aggr(spath, spoint) PARALLEL SAFE;
ALTER FUNCTION spath_add_points_fin_aggr(spath) PARALLEL SAFE;

-- spoint
ALTER FUNCTION spoint(FLOAT8, FLOAT8) PARALLEL SAFE;
ALTER FUNCTION long(spoint) PARALLEL SAFE;
ALTER FUNCTION lat(spoint) PARALLEL SAFE;
ALTER FUNCTION x(spoint) PARALLEL SAFE;
ALTER FUNCTION y(spoint) PARALLEL SAFE;
ALTER FUNCTION xyz(spoint) PARALLEL SAFE;
ALTER FUNCTION z(spoint) PARALLEL SAFE;
ALTER FUNCTION spoint_equal(spoint, spoint) PARALLEL SAFE;
ALTER FUNCTION spoint_equal_neg(spoint, spoint) PARALLEL SAFE;
ALTER FUNCTION dist(spoint, spoint) PARALLEL SAFE;

-- spoly
ALTER FUNCTION npoints(spoly) PARALLEL SAFE;
ALTER FUNCTION area(spoly) PARALLEL SAFE;
ALTER FUNCTION spoly_equal(spoly, spoly) PARALLEL SAFE;
ALTER FUNCTION spoly_not_equal(spoly, spoly) PARALLEL SAFE;
ALTER FUNCTION circum(spoly) PARALLEL SAFE;
ALTER FUNCTION spoly_contains_polygon(spoly, spoly) PARALLEL SAFE;
ALTER FUNCTION spoly_contains_polygon_com(spoly, spoly) PARALLEL SAFE;
ALTER FUNCTION spoly_contains_polygon_neg(spoly, spoly) PARALLEL SAFE;
ALTER FUNCTION spoly_contains_polygon_com_neg(spoly, spoly) PARALLEL SAFE;
ALTER FUNCTION spoly_overlap_polygon(spoly, spoly) PARALLEL SAFE;
ALTER FUNCTION spoly_overlap_polygon_neg(spoly, spoly) PARALLEL SAFE;
ALTER FUNCTION spoly_contains_point(spoly, spoint) PARALLEL SAFE;
ALTER FUNCTION spoly_contains_point_com(spoint, spoly) PARALLEL SAFE;
ALTER FUNCTION spoly_contains_point_neg(spoly, spoint) PARALLEL SAFE;
ALTER FUNCTION spoly_contains_point_com_neg(spoint, spoly) PARALLEL SAFE;
ALTER FUNCTION strans_poly(spoly, strans) PARALLEL SAFE;
ALTER FUNCTION strans_poly_inverse(spoly, strans) PARALLEL SAFE;
ALTER FUNCTION spoly_contains_circle(spoly, scircle) PARALLEL SAFE;
ALTER FUNCTION spoly_contains_circle_com(scircle, spoly) PARALLEL SAFE;
ALTER FUNCTION spoly_contains_circle_neg(spoly, scircle) PARALLEL SAFE;
ALTER FUNCTION spoly_contains_circle_com_neg(scircle, spoly) PARALLEL SAFE;
ALTER FUNCTION scircle_contains_polygon(scircle, spoly) PARALLEL SAFE;
ALTER FUNCTION scircle_contains_polygon_com(spoly, scircle) PARALLEL SAFE;
ALTER FUNCTION scircle_contains_polygon_neg(scircle, spoly) PARALLEL SAFE;
ALTER FUNCTION scircle_contains_polygon_com_neg(spoly, scircle) PARALLEL SAFE;
ALTER FUNCTION spoly_overlap_circle(spoly, scircle) PARALLEL SAFE;
ALTER FUNCTION spoly_overlap_circle_com(scircle, spoly) PARALLEL SAFE;
ALTER FUNCTION spoly_overlap_circle_neg(spoly, scircle) PARALLEL SAFE;
ALTER FUNCTION spoly_overlap_circle_com_neg(scircle, spoly) PARALLEL SAFE;
ALTER FUNCTION spoly_contains_line(spoly, sline) PARALLEL SAFE;
ALTER FUNCTION spoly_contains_line_com(sline, spoly) PARALLEL SAFE;
ALTER FUNCTION spoly_contains_line_neg(spoly, sline) PARALLEL SAFE;
ALTER FUNCTION spoly_contains_line_com_neg(sline, spoly) PARALLEL SAFE;
ALTER FUNCTION spoly_overlap_line(spoly, sline) PARALLEL SAFE;
ALTER FUNCTION spoly_overlap_line_com(sline, spoly) PARALLEL SAFE;
ALTER FUNCTION spoly_overlap_line_neg(spoly, sline) PARALLEL SAFE;
ALTER FUNCTION spoly_overlap_line_com_neg(sline, spoly) PARALLEL SAFE;
ALTER FUNCTION spoly_contains_ellipse(spoly, sellipse) PARALLEL SAFE;
ALTER FUNCTION spoly_contains_ellipse_com(sellipse, spoly) PARALLEL SAFE;
ALTER FUNCTION spoly_contains_ellipse_neg(spoly, sellipse) PARALLEL SAFE;
ALTER FUNCTION spoly_contains_ellipse_com_neg(sellipse, spoly) PARALLEL SAFE;
ALTER FUNCTION sellipse_contains_polygon(sellipse, spoly) PARALLEL SAFE;
ALTER FUNCTION sellipse_contains_polygon_com(spoly, sellipse) PARALLEL SAFE;
ALTER FUNCTION sellipse_contains_polygon_neg(sellipse, spoly) PARALLEL SAFE;
ALTER FUNCTION sellipse_contains_polygon_com_neg(spoly, sellipse) PARALLEL SAFE;
ALTER FUNCTION spoly_overlap_ellipse(spoly, sellipse) PARALLEL SAFE;
ALTER FUNCTION spoly_overlap_ellipse_com(sellipse, spoly) PARALLEL SAFE;
ALTER FUNCTION spoly_overlap_ellipse_neg(spoly, sellipse) PARALLEL SAFE;
ALTER FUNCTION spoly_overlap_ellipse_com_neg(sellipse, spoly) PARALLEL SAFE;
ALTER FUNCTION spoly_add_point_aggr(spoly, spoint) PARALLEL SAFE;
ALTER FUNCTION spoly_add_points_fin_aggr(spoly) PARALLEL SAFE;

-- gist_spoint3
ALTER FUNCTION g_spoint3_penalty(internal, internal, internal) PARALLEL SAFE;
ALTER FUNCTION g_spoint3_fetch(internal) PARALLEL SAFE;

