<?php

  // Database connection settings
  define("PG_DB"  , "routing");
  define("PG_HOST", "localhost"); 
  define("PG_USER", "postgres");
  define("PG_PORT", "5432"); 
  define("TABLE",   "victoria"); 

  $counter = $pathlength = 0;

  // Retrieve start point
  $start = split(' ',$_REQUEST['startpoint']);
  $startPoint = array($start[0], $start[1]);
  
  // Retrieve end point
  $end = split(' ',$_REQUEST['finalpoint']);
  $endPoint = array($end[0], $end[1]);

  // Find the nearest edge
  $startEdge = findNearestEdge($startPoint);
  $endEdge   = findNearestEdge($endPoint);

  // FUNCTION findNearestEdge
  function findNearestEdge($lonlat) {
    
    // Connect to database
    $con = pg_connect("dbname=".PG_DB." host=".PG_HOST." user=".PG_USER);
    
    $sql = "SELECT gid, source, target, the_geom, 
			 distance(the_geom, GeometryFromText(
                  'POINT(".$lonlat[0]." ".$lonlat[1].")', 54004)) AS dist 
            FROM ".TABLE."  
            WHERE the_geom && setsrid(
                  'BOX3D(".($lonlat[0]-200)." 
                         ".($lonlat[1]-200).", 
                         ".($lonlat[0]+200)." 
                         ".($lonlat[1]+200).")'::box3d, 54004) 
            ORDER BY dist LIMIT 1";

    $query = pg_query($con,$sql);  
    
    $edge['gid']      = pg_fetch_result($query, 0, 0);  
    $edge['source']   = pg_fetch_result($query, 0, 1);  
    $edge['target']   = pg_fetch_result($query, 0, 2);  
    $edge['the_geom'] = pg_fetch_result($query, 0, 3);  

    // Close database connection
    pg_close($con);

    return $edge;
  }
  
?>