/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import main.Node;

public class Main {
    static List<String> Spalten;
    static int id;
    static String lon;
    static String lat;
    static HashMap<String, String> KeyValue;
    static List<Node> NodeList;
    static boolean nodeGefunden;
    static String tabelleerstellennodes;
    static String tabellefuellennodes;
    static List<String> StringList;

    static {
        NodeList = new ArrayList<Node>();
        tabelleerstellennodes = "";
        tabellefuellennodes = "";
        StringList = new ArrayList<String>();
    }

    public static void main(String[] args) throws Exception {
        long zstVorher = System.currentTimeMillis();
        Spalten = new ArrayList<String>();
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(new FileInputStream(args[0]));
        while (xmlStreamReader.hasNext()) {
            switch (xmlStreamReader.next()) {
                case 1: {
                    Main.handleStartElement(xmlStreamReader);
                    break;
                }
                case 2: {
                    Main.handleEndElement(xmlStreamReader);
                    break;
                }
            }
        }
        xmlStreamReader.close();
        Collections.sort(Spalten);
        File schreiben = new File("nodeerstellen.sql");
        File schreiben1 = new File("nodefuellen.sql");
        if (!schreiben.exists()) {
            schreiben.createNewFile();
        } else {
            schreiben.delete();
            schreiben.createNewFile();
        }
        if (!schreiben1.exists()) {
            schreiben1.createNewFile();
        } else {
            schreiben1.delete();
            schreiben1.createNewFile();
        }
        FileWriter write = new FileWriter(schreiben);
        FileWriter write1 = new FileWriter(schreiben1);
        System.out.println("Knoten ausgelesen und gespeichert!");
        Main.TabellenStrukturNodes(Spalten);
        write.write(tabelleerstellennodes);
        write.write("INSERT INTO geometry_columns (f_table_catalog, f_table_schema, f_table_name, f_geometry_column, coord_dimension, srid, type) values ('\"', 'public', 'nodes', 'the_geom', '2', '4326', 'POINT');");
        write.flush();
        write.close();
        System.out.println("Struktur erstellt!");
        Main.TabelleFuellenNodes(NodeList);
        int i = 1;
        double prozent = 0.0;
        double prozvorher = 0.0;
        for (String z : StringList) {
            int Anzahl = StringList.size();
            if (tabellefuellennodes.length() >= 50) {
                write1.write(tabellefuellennodes);
                tabellefuellennodes = "";
            }
            tabellefuellennodes = String.valueOf(tabellefuellennodes) + z;
            prozvorher = prozent;
            if (prozvorher != (prozent = (double)(i * 100 / Anzahl))) {
                System.out.println(String.valueOf(prozent) + "%");
            }
            ++i;
        }
        write1.write(tabellefuellennodes);
        write1.flush();
        write1.close();
        long zstNachher = System.currentTimeMillis();
        System.out.println("Zeit ben\u00f6tigt: " + (zstNachher - zstVorher) / 1000L + " sec");
    }

    private static void handleEndElement(XMLStreamReader xmlStreamReader) {
        if (xmlStreamReader.getName().toString().equals("node")) {
            nodeGefunden = false;
            if (!KeyValue.isEmpty()) {
                NodeList.add(new Node(id, lat, lon, KeyValue));
            }
        }
    }

    private static void handleStartElement(XMLStreamReader xmlStreamReader) {
        if (xmlStreamReader.getName().toString().equals("tag")) {
            if (!Spalten.contains(xmlStreamReader.getAttributeValue(null, "k").toString())) {
                Spalten.add(xmlStreamReader.getAttributeValue(null, "k"));
            }
            if (nodeGefunden) {
                KeyValue.put(xmlStreamReader.getAttributeValue(null, "k"), xmlStreamReader.getAttributeValue(null, "v"));
            }
        }
        if (xmlStreamReader.getName().toString().equals("node")) {
            id = Integer.parseInt(xmlStreamReader.getAttributeValue(null, "id"));
            lon = xmlStreamReader.getAttributeValue(null, "lon");
            lat = xmlStreamReader.getAttributeValue(null, "lat");
            KeyValue = new HashMap();
            nodeGefunden = true;
        }
    }

    public static void TabellenStrukturNodes(List<String> Spalten) {
        if (Spalten.size() > 0) {
            tabelleerstellennodes = "create table nodes (\"id\" int, \"the_geom\" geometry, ";
            tabelleerstellennodes = String.valueOf(tabelleerstellennodes) + "\"" + Spalten.get(0) + "\" text";
            Spalten.remove(0);
            for (String b : Spalten) {
                tabelleerstellennodes = String.valueOf(tabelleerstellennodes) + ", \"" + b + "\" text";
            }
            tabelleerstellennodes = String.valueOf(tabelleerstellennodes) + "); ALTER TABLE nodes add primary key (id);";
        } else {
            tabelleerstellennodes = "create table nodes (\"id\" int, \"the_geom\" geometry); ALTER TABLE nodes add primary key (id); ";
        }
    }

    public static void TabelleFuellenNodes(List<Node> nodes) {
        int i = 1;
        for (Node node : nodes) {
            StringList.add("INSERT INTO nodes (id");
            if (!node.getAttribute().isEmpty()) {
                for (String n : node.getAttribute().keySet()) {
                    StringList.add(", \"" + n + "\" ");
                }
                StringList.add(", the_geom)");
            } else {
                StringList.add(", the_geom)");
            }
            StringList.add(" values(" + node.getId());
            if (!node.getAttribute().isEmpty()) {
                for (String n : node.getAttribute().keySet()) {
                    if (!node.getAttribute().get(n).contains("'")) {
                        StringList.add(", '" + node.getAttribute().get(n) + "'");
                        continue;
                    }
                    String knoten = node.getAttribute().get(n);
                    String helfen = knoten.replaceAll("'", "");
                    System.out.println(helfen);
                    StringList.add(", '" + helfen + "'");
                }
                StringList.add(", GeomfromEWKT('SRID=4326; POINT (" + node.getLon() + " " + node.getLat() + ")')); ");
            } else {
                StringList.add(", GeomfromEWKT('SRID=4326; POINT (" + node.getLon() + " " + node.getLat() + ")')); ");
            }
            System.out.println(String.valueOf(i) + " von " + nodes.size());
            ++i;
        }
    }
}

