create table nodes(
id bigint not null,
numsofuse integer default 0,
lon double precision,
lat double precision
);

create table ways_tmp(
id integer not null,
name varchar(100),
constraint pk_ways_tmp Primary Key (id)
);

create table nodes2way(
idway integer not null,
idnode integer not null,
constraint fk_nodes2way_idway Foreign Key (idway) references ways_tmp(id),
constraint fk_nodes2way_idnode Foreign Key (idnode) references nodes(id)
);

insert into ways_tmp(id, name) values(1,'Teststraße');

insert into nodes2way(idway,idnode) values(1,111480817);
insert into nodes2way(idway,idnode) values(1,111481814);
insert into nodes2way(idway,idnode) values(1,1114858201);


select a.name, b.lon from nodes b inner join nodes2way c on b.id = c.idnode inner join ways_tmp a on a.id = c.idway;


create or replace function split_ways() Returns void
AS $$ 
Declare
current_way_id integer;
current_node_id integer;
cursor_ways_tmp Cursor FOR SELECT id from ways_tmp;
cursor_nodes_tmp Cursor (way_id integer) is SELECT idnode from nodes2way where idway=way_id;

test varchar(100000);
street_name varchar(50);	
node_numofuse integer;
geo_id integer;
num_of_points integer;
end_found boolean; -- Das Ende einer Teilstrecke gefunden
first_point_x double precision;
first_point_y double precision;
last_point_x double precision;
last_point_y double precision;
begin
	geo_id:=0;
	open cursor_ways_tmp;
	LOOP 
		FETCH cursor_ways_tmp INTO current_way_id;
		if not found then
		   exit ;
		end if;
		
		Select name into street_name from ways_tmp where id=current_way_id;
		
		end_found:=false;
		open cursor_nodes_tmp(current_way_id);

		-- fetch alle Nodes zum aktuellen Weg
		LOOP
			
			if end_found is false then
				FETCH cursor_nodes_tmp INTO current_node_id;
				if not found then
				   exit ;
				end if;
			end if;
			
			-- end_founf wieder auf false setzen, current_node_id beim Endpunkt der letzten Teilstrecke
			if end_found is true then
				end_found:=false;
			end if;

			-- Anfangspunkt der Teilstrecke
			Select lon into first_point_x from nodes where id=current_node_id ;
			Select lat into first_point_y from nodes where id=current_node_id ;
			num_of_points:=0;
			num_of_points:=num_of_points+1;
			test := 'MULTILINESTRING((' || text(first_point_x ) || ' ' || text(first_point_y ); 
			geo_id:=geo_id+1;
			
			-- zweite loop, um erste Teilstrecke zusammenzubasteln
			LOOP
				FETCH cursor_nodes_tmp INTO current_node_id;
				
				-- Es kommt kein weitere Punkt, Multilinestring schliessen
				if not found then
					test:= test || '))';
					
					-- Geometry hat nur ein Punkt, Fehler...., nciht abspeichern
					if num_of_points = 1 then
						exit;
					end if;
					
					Insert into ways(gid, the_geom, name,x1,y1,x2,y2) values( geo_id ,GeometryFromText( test, 4326), street_name,first_point_x,first_point_y,last_point_x,last_point_y);
				   
				   exit ;
				end if;
				
				Select numofuse into node_numofuse from nodes where id =current_node_id;
				
				Select lon into last_point_x from nodes where id =current_node_id;
				Select lat into last_point_y from nodes where id =current_node_id;

				-- Wenn der Punkt nur maximal einmal benutzt wird Zwischenpunkt
				-- Wenn der Punkt mehrmals genutzt wird, ist die Teilstrecke zu Ende
				if node_numofuse > 1 then
					
					test:= test || ',' || text(last_point_x ) || ' ' || text(last_point_y ) || '))'; 
					-- writing Teilstrecke/Weg in die DB
					Insert into ways(gid, the_geom, name,x1,y1,x2,y2) values( geo_id ,GeometryFromText( test, 4326), street_name,first_point_x,first_point_y,last_point_x,last_point_y);
					end_found:=true; -- Ein Ende der Teilstrecke gefunden, Endpunkt, als Afangspunkt der naechsten Teilstrecke nutzen
					exit;
				else
					test:= test || ',' || text(last_point_x ) || ' ' || text(last_point_y ); 
				
				end if;
				
			
			end LOOP;
						
			
		end loop;
		close cursor_nodes_tmp;

		
	end loop;
	close cursor_ways_tmp;
	--return test;
	--return 10;
end;
$$ language plpgsql;


create or replace function calculate_costs() Returns void
AS $$ 
Declare
cursor_ways Cursor FOR SELECT gid from ways;
way_id integer;
length double precision;
begin

	open cursor_ways;
	LOOP 
		FETCH cursor_ways INTO way_id;
		if not found then
		   exit ;
		end if;
	Select ST_length(the_geom) into length from ways where gid=way_id;
	UPDATE ways set to_cost=length where gid=way_id;

	end loop;
	close cursor_ways;
end;
$$ language plpgsql;
