//----------------------------------------------------------------------------
// File: ossimSqliteUtil.h
//
// License:  LGPL
// 
// See LICENSE.txt file in the top level directory for more details.
//
// Description: OSSIM SQLite utility class.
//
//----------------------------------------------------------------------------
// $Id

#ifndef ossimSqliteUtil_HEADER
#define ossimSqliteUtil_HEADER 1

#include <string>

struct sqlite3;

namespace ossim_sqlite
{
   /**
    * @brief Preforms sqlite3_prepare_v2, sqlite3_step and sqlite3_finalize.
    * @param db
    * @param sql 
    * @return return code of last command executed.  Typically this is the
    * return of sqlite3_step but could be return of sqlite3_prepare_v2 if
    * it had an error, i.e. return is not SQLITE_OK.
    */   
   int exec( sqlite3* db, const std::string& sql );
   
} // End: namespace ossim_sqlite

#endif /* #ifndef ossimSqliteUtil_HEADER */
