//----------------------------------------------------------------------------
// File: ossimGpkgUtil.cpp
// 
// License:  LGPL
// 
// See LICENSE.txt file in the top level directory for more details.
//
// Description: OSSIM SQLite utility class.
//----------------------------------------------------------------------------
// $Id$

#include "ossimSqliteUtil.h"
#include <ossim/base/ossimNotify.h>
#include <ossim/base/ossimTrace.h>

#include <sqlite3.h>

static ossimTrace traceDebug("ossimSqliteUtil:debug");

int ossim_sqlite::exec( sqlite3* db, const std::string& sql )
{
   int rc = SQLITE_ERROR;
   if ( db && sql.size() )
   {
      if (traceDebug())
      {
         ossimNotify(ossimNotifyLevel_DEBUG)
            << "sql:\n" << sql << "\n";
      }

      sqlite3_stmt* pStmt = 0; // The current SQL statement

      rc = sqlite3_prepare_v2(db,          // Database handle
                              sql.c_str(), // SQL statement, UTF-8 encoded
                              -1,          // Maximum length of zSql in bytes.
                              &pStmt,      // OUT: Statement handle
                              NULL);
      if ( rc == SQLITE_OK )
      {
         rc = sqlite3_step(pStmt);
      }
      else
      {
         ossimNotify(ossimNotifyLevel_WARN)
            << "ossim_sqlite::exec error: " << sqlite3_errmsg(db) << std::endl;
      }
      
      sqlite3_finalize(pStmt);
   }
   return rc;
}
