//----------------------------------------------------------------------------
//
// File: ossimGpkgSpatialRefSysRecord.h
//
// License:  LGPL
// 
// See LICENSE.txt file in the top level directory for more details.
//
// Description: Container class for gpkg_spatial_ref_sys table.
//
//----------------------------------------------------------------------------
// $Id$

#ifndef ossimGpkgSpatialRefSysRecord_HEADER
#define ossimGpkgSpatialRefSysRecord_HEADER 1

#include "ossimGpkgDatabaseRecordBase.h"
#include <ossim/base/ossimConstants.h>

class ossimMapProjection;
struct sqlite3;

class ossimGpkgSpatialRefSysRecord : public ossimGpkgDatabaseRecordBase
{
public:

   /** @brief default constructor */
   ossimGpkgSpatialRefSysRecord();

   /* @brief copy constructor */
   ossimGpkgSpatialRefSysRecord(const ossimGpkgSpatialRefSysRecord& obj);

   /* @brief assignment operator= */
   const ossimGpkgSpatialRefSysRecord& operator=(const ossimGpkgSpatialRefSysRecord& obj);

   /** @brief destructor */
   virtual ~ossimGpkgSpatialRefSysRecord();

   /**
    * @brief Initialize from database.
    * @param pStmt SQL statement, i.e. result of sqlite3_prepare_v2(...) call.
    * @return true on success, false on error.
    */
   virtual bool init( sqlite3_stmt* pStmt );

   /**
    * @brief Initialize from projection.
    * @param proj Output map projection.
    * @return true on success, false on error.
    */
   bool init( const ossimMapProjection* proj );

   /**
    * @brief Creates gpkg_contents table in database.
    * @param db
    * @return true on success, false on error.
    */   
   static bool createTable( sqlite3* db );

   /**
    * @brief Inserst this record into gpkg_contents table.
    * @param db
    * @return true on success, false on error.
    */   
   bool insert( sqlite3* db );   

   /**
    * @brief Saves the state of object.
    * @param kwl Initialized by this.
    * @param prefix e.g. "image0.". Can be empty.
    */
   virtual void saveState( ossimKeywordlist& kwl, const std::string& prefix ) const;



   std::string   m_srs_name;
   ossim_int32   m_srs_id;
   std::string   m_organization;
   ossim_int32   m_organization_coordsys_id;
   std::string   m_definition;
   std::string   m_description;
};

#endif /* #ifndef ossimGpkgSpatialRefSysRecord_HEADER */
