#ifndef ossimModelOptimizer_HEADER
#define ossimModelOptimizer_HEADER

#include <ossim/base/ossimObject.h>
#include <ossim/base/ossimConnectableObject.h>
#include <ossim/base/ossimPropertyInterface.h>
#include <ossim/base/ossimProcessInterface.h>
#include <ossim/base/ossimProcessProgressEvent.h>
#include <ossim/base/ossimRefPtr.h>
#include <ossim/base/ossimString.h>
#include <ossim/base/ossimTieGptSet.h>
#include <ossim/projection/ossimProjection.h>
#include "ossimRegistrationExports.h"

/*!
 * class ossimModelOptimizer
 * class for optimizing an existing projection model or creating new model from a set of tie points
 *
 * you can use ossimImageCorrelator to get an input (object ossimTieGptSet)
 *
 */
class OSSIM_REGISTRATION_DLL ossimModelOptimizer : public ossimConnectableObject,
                                                   public ossimProcessInterface
{
public:
   ossimModelOptimizer();
   virtual ~ossimModelOptimizer() {}

   bool canConnectMyInputTo(ossim_int32 inputIndex,
                            const ossimConnectableObject* object)const
   {
      return false;
   }
  /*!
   * accessors to parms
   */   
   inline void  setTieSet(const ossimTieGptSet& aTieSet) { theTieSet=aTieSet; }
   inline const ossimTieGptSet& getTieSet()const { return theTieSet; }

   inline void  setTiesetFilename(const ossimString& t) { theTiesetFilename = t; }
   inline const ossimString& getTiesetFilename()const { return theTiesetFilename; }

   inline void  setModelDefinitionString(const ossimString& t) { theModelDefinitionString = t; }
   inline const ossimString& getModelDefinitionString()const { return theModelDefinitionString; }

   inline void  setGeomOutputFilename(const ossimFilename& op) { theGeomOutputFilename=op; }
   inline const ossimFilename& getGeomOutputFilename()const { return theGeomOutputFilename; }

   inline ossimRefPtr< ossimProjection > refModel()const { return theModel; }

   bool loadGMLTieSet(const ossimString& filepath); //! file can be generated by correl

   virtual bool setupModel(const ossimString& description);
   virtual bool exportModel(const ossimFilename& geomFile)const;

   /*!
    * ossimObject interface
    */
   virtual       ossimObject* getObject()      { return this; }
   virtual const ossimObject* getObject()const { return this; }
   virtual       ossimObject* getObjectInterface() { return this; }

   /*!
    * property interface
    */
   virtual void setProperty(ossimRefPtr<ossimProperty> property);
   virtual ossimRefPtr<ossimProperty> getProperty(const ossimString& name)const;
   virtual void getPropertyNames(std::vector<ossimString>& propertyNames)const;

   /* !
    * optimization method: 
    * returns: true for success
    *          variance , unit pixel^2(if pointer not NULL)
    * INPUT: target variance in pixel^2 (optional)
    */
   virtual bool optimize(ossim_float64* result_var_pix2 = NULL,
                         ossim_float64* target_var_pix2 = NULL);

   virtual bool execute(); //!process interface to run model optimization

protected:
   ossimTieGptSet                 theTieSet;
   ossimString                    theTiesetFilename;
   ossimString                    theModelDefinitionString;
   ossimFilename                  theGeomOutputFilename;
   ossimRefPtr< ossimProjection > theModel;

   inline ossimModelOptimizer(const ossimModelOptimizer& copyme) {} //!disable copy constructor
   TYPE_DATA
};

#endif //ossimModelOptimizer_HEADER
