//----------------------------------------------------------------------------
//
// File: ossimLasPointRecord1.h
//
// License:  LGPL
// 
// See LICENSE.txt file in the top level directory for more details.
//
// Author:  David Burken
//
// Description: Container class for LAS point record type 1.
//
//----------------------------------------------------------------------------
// $Id: ossimLasPointRecord1.h 2645 2011-05-26 15:21:34Z oscar.kramer $
#ifndef ossimLasPointRecord3_HEADER
#define ossimLasPointRecord3_HEADER 1

#include "ossimLasPointRecordInterface.h"

class ossimLasPointRecord3 : public ossimLasPointRecordInterface
{
public:

   /** @brief default constructor */
   ossimLasPointRecord3();

   /* @brief copy constructor */
   ossimLasPointRecord3(const ossimLasPointRecord3& obj);

   /* @brief assignment operator= */
   const ossimLasPointRecord3& operator=(const ossimLasPointRecord3& copy_this);

   /** @brief destructor */
   virtual ~ossimLasPointRecord3();

   /** @brief Initialize record from stream. */
   virtual void readStream(std::istream& in);

   /** @brief Writes record to stream. */
   virtual void writeStream(std::ostream& out);

   /** @return x */
   virtual ossim_int32 getX() const;

   /** @return y */
   virtual ossim_int32 getY() const;
   
   /** @return z */
   virtual ossim_int32 getZ() const;

   /** @return return number */
   virtual ossim_uint8 getReturnNumber() const;

   virtual ossim_uint8 getNumberOfReturns() const;
   
   virtual ossim_uint8 getEdgeFlag() const;
      
   virtual std::ostream& print(std::ostream& out) const;

private:

   /** @brief Performs a swap if system byte order is not little endian. */
   void swap();

   union BitFlags
   {
      BitFlags(const BitFlags& obj):m_bits(obj.m_bits){}
      BitFlags(ossim_uint32 value):m_bits((ossim_uint8)value){}
      const BitFlags& operator =(const BitFlags& obj){m_bits = obj.m_bits;return *this;}
      struct
      {
         ossim_uint8 m_returnNumber : 3;
         ossim_uint8 m_numberOfReturns : 3;
         ossim_uint8 m_scanDirection : 1;
         ossim_uint8 m_edgeOfFlightLine : 1;
      };
      ossim_uint8 m_bits;
   };   //---
   // Private structure so we can do a single read/write in the readStream
   // and writeStream methods.  This sped the code up 5X when doing an ossim-icp
   // from a LAS file to a tif.
   //---
   struct ossimLasPointRecord3Data
   {
      ossimLasPointRecord3Data();
      ossimLasPointRecord3Data(const ossimLasPointRecord3Data& obj);
      const ossimLasPointRecord3Data& operator=(const ossimLasPointRecord3Data& obj);
      ossim_int32   m_x;
      ossim_int32   m_y;
      ossim_int32   m_z;
      ossim_uint16  m_intensity;
      BitFlags      m_bitFlags;
      ossim_uint8   m_classification;
      ossim_int8    m_scanAngleRank;
      ossim_uint8   m_userData;
      ossim_uint16  m_pointSourceId;
      //ossim_uint8   m_returnByte;
      //ossim_uint8   m_classification;
      //ossim_int8    m_scanAngleRank;
      //ossim_uint8   m_userData;
      //ossim_uint16  m_pointSourceID;
      //ossim_float64 m_gpsTime;
   };
   
   ossimLasPointRecord3Data m_record;
};

#endif /* #ifndef ossimLasPointRecord3_HEADER */
