#!/bin/sh

# File: ossim-cmake-config.sh

build_dir=$OSSIM_DEV_HOME
install_dir=$OSSIM_INSTALL_PREFIX

cmake -G "Unix Makefiles" \
-DBUILD_CSMAPI=OFF \
-DBUILD_LIBRARY_DIR=lib \
-DBUILD_OMAR=ON \
-DBUILD_OMS=ON \
-DBUILD_OSSIM=ON \
-DBUILD_OSSIM_PLUGIN=ON  \
-DBUILD_OSSIMCONTRIB_PLUGIN=ON \
-DBUILD_OSSIMCSM_PLUGIN=OFF \
-DBUILD_OSSIMGEOPDF_PLUGIN=ON \
-DBUILD_OSSIMGDAL_PLUGIN=ON \
-DBUILD_OSSIMHDF_PLUGIN=ON \
-DBUILD_OSSIMJNI=ON \
-DBUILD_OSSIMKAKADU_PLUGIN=ON \
-DBUILD_OSSIMKMLSUPEROVERLAY_PLUGIN=OFF \
-DBUILD_OSSIMLAS_PLUGIN=ON \
-DBUILD_OSSIMLIBLAS_PLUGIN=OFF \
-DBUILD_OSSIMLIBRAW_PLUGIN=ON \
-DBUILD_OSSIMMRSID_PLUGIN=ON \
-DBUILD_OSSIMNDF_PLUGIN=ON \
-DBUILD_OSSIMNUI_PLUGIN=ON \
-DBUILD_OSSIMOPENJPEG_PLUGIN=OFF \
-DBUILD_OSSIMPNG_PLUGIN=ON \
-DBUILD_OSSIMREGISTRATION_PLUGIN=OFF \
-DBUILD_OSSIMWEB_PLUGIN=ON \
-DBUILD_OSSIMQT4=ON \
-DBUILD_OSSIMGUI=ON \
-DBUILD_OSSIM_MPI_SUPPORT=OFF \
-DBUILD_OSSIMPLANET=ON \
-DBUILD_OSSIMPLANETQT=OFF \
-DBUILD_OSSIMPREDATOR=ON \
-DBUILD_OSSIM_TEST_APPS=ON \
-DBUILD_RAPIER_TEST_APPS=ON \
-DBUILD_RUNTIME_DIR=bin \
-DBUILD_SHARED_LIBS=ON \
-DBUILD_WMS=ON \
-DCMAKE_BUILD_TYPE=RELEASE \
-DCMAKE_INCLUDE_PATH=$install_dir/include \
-DCMAKE_INSTALL_PREFIX=$install_dir \
-DCMAKE_LIBRARY_PATH=$install_dir/lib \
-DCMAKE_MODULE_PATH=$build_dir/ossim_package_support/cmake/CMakeModules \
-DHDF5_LIBRARIES="hdf5;hdf5_cpp" \
-DKAKADU_ROOT_SRC=$build_dir/kakadu/latest \
-DKAKADU_AUX_LIBRARY=$install_dir/lib/libkdu_a72R.so \
-DKAKADU_LIBRARY=$install_dir/lib/libkdu_v72R.so  \
-DMRSID_DIR=$build_dir/mrsid/latest \
-DOSSIM_COMPILE_WITH_FULL_WARNING=ON \
-DOSSIM_DEPENDENCIES=$build_dir/deps \
-DOSSIM_INSTALL_PLUGINS_WITH_VERSION=OFF \
-DOSSIM_PLUGIN_LINK_TYPE=MODULE \
-DOSSIMPLANET_ENABLE_EPHEMERIS=ON \
$build_dir/ossim_package_support/cmake/

# -DCMAKE_CXX_FLAGS_DEBUG="-g -O0" \


# -DHDF5_LIBRARIES="hdf5;hdf5_cpp;hdf5_tools" \
# -DCMAKE_CXX_FLAGS_RELEASE="-O2 -pg" \
# -DKAKADU_LIBRARY="$build_dir/local/lib64/libkdu_a64R.so $build_dir/local/lib64/libkdu_v64R.so"  \
# -DMPI_LIBRARIES="/usr/lib64/openmpi/lib/libmpi_cxx.so /usr/lib64/openmpi/lib/libmpi.so"\
# -DOSSIM_BUILD_ADDITIONAL_DIRECTORIES="$build_dir/Rapier;$build_dir/ossim_rapier_plugin" \
# -DOSSIM_BUILD_ADDITIONAL_DIRECTORIES="$build_dir/Rapier;$build_dir/ossim_rapier_plugin" \
# -DOSSIM_BUILD_ADDITIONAL_DIRECTORIES="$build_dir/ossimjni;$build_dir/Rapier" \
# -DCMAKE_CXX_FLAGS_DEBUG="-g -O0 "\
# -DMRSID_DIR=$build_dir/mrsid \
