//----------------------------------------------------------------------------
//
// License:  LGPL
// 
// See LICENSE.txt file in the top level directory for more details.
//
// Author:  David Burken
//
// Description: Interface for codec(encoder/decoder) factories.
// 
//----------------------------------------------------------------------------
// $Id$
#ifndef ossimCodecFactoryInterface_HEADER
#define ossimCodecFactoryInterface_HEADER 1

#include <ossim/base/ossimConstants.h>
#include <ossim/base/ossimRefPtr.h>
#include <vector>

class ossimImageData;
class ossimKeywordlist;

/**
 * @brief Codec factory interface.
 */
class OSSIM_DLL ossimCodecFactoryInterface // : public ossimObjectFactory
{
public:

   /** default constructor */
   ossimCodecFactoryInterface(){}

   /** virtual destructor */
   virtual ~ossimCodecFactoryInterface(){}

   /**
    * @brief Pure virtual decode method. Derived classes must implement to
    * be concrete.
    *
    * @param in Input data to decode.
    * 
    * @param out Output tile.
    *
    * @return true on success, false on failure.
    */
   virtual bool decode( const std::vector<ossim_uint8>& in,
                        ossimRefPtr<ossimImageData>& out ) const = 0;

   /**
    * @brief Pure virtual encode method. Derived classes must implement to
    * be concrete.
    *
    * @param in Input data to encode.
    * 
    * @param out Encoded output data.
    *
    * @return true on success, false on failure.
    */

   virtual bool encode( const ossimKeywordlist& options,
                        const ossimRefPtr<ossimImageData>& in,
                        std::vector<ossim_uint8>& out ) const = 0;
};

#endif /* End of "#ifndef ossimCodecFactoryInterface_HEADER" */
