//-----------------------------------------------------------------------------
// File:  Info.cpp
//
// License:  See top level LICENSE.txt file.
//
// Author:  David Burken
//
// Description: Class definition for Info.
//
//-----------------------------------------------------------------------------
// $Id: Info.cpp 22320 2013-07-19 15:21:03Z dburken $

#include <oms/Info.h>
#include <oms/Keywordlist.h>
#include <ossim/base/ossimArgumentParser.h>
#include <ossim/base/ossimFilename.h>
#include <ossim/base/ossimKeywordlist.h>
#include <ossim/base/ossimNotify.h>
#include <ossim/util/ossimInfo.h>

oms::Info::Info() :
   m_info(new ossimInfo)
{
}
      
oms::Info::~Info()
{
   if (m_info)
   {
      delete m_info;
      m_info = 0;
   }
}

bool oms::Info::initialize(int argc, char* argv[])
{
   ossimArgumentParser ap(&argc, argv);
   return m_info->initialize(ap);
}

void oms::Info::execute()
{
   m_info->execute();
}

void oms::Info::getImageInfo( const std::string& file,
                              bool dumpFlag,
                              bool dnoFlag,
                              bool imageGeomFlag,
                              bool imageInfoFlag,
                              bool metaDataFlag,
                              bool paletteFlag,
                              oms::Keywordlist* kwl) const
{
   if ( kwl )
   {
      m_info->getImageInfo(ossimFilename(file),
                           dumpFlag,
                           dnoFlag,
                           imageGeomFlag,
                           imageInfoFlag,
                           metaDataFlag,
                           paletteFlag,
                           *(kwl->getKeywordlist()) );
   }
}

bool oms::Info::getImageInfo( const std::string& file,
                              int entry,
                              oms::Keywordlist* kwl) const
{
   bool result = false;
   
   if ( kwl )
   {
      ossim_uint32 entryIndex = 0;
      if ( entry > -1 )
      {
         entryIndex = (ossim_uint32)entry;
      }

      result = m_info->getImageInfo( ossimFilename(file),
                                     entryIndex,
                                     *(kwl->getKeywordlist()) );
   }

   return result;
}

void oms::Info::closeImage()
{
   m_info->closeImage();
}
