//----------------------------------------------------------------------------
// License:  See top level LICENSE.txt file.
//
// Author:  David Burken
//
// Description:  Simple container class to encapsulate image info.
//
//----------------------------------------------------------------------------
// $Id: ImageInfo.h 12991 2008-06-04 19:14:59Z gpotts $
#ifndef omsImageInfo_HEADER
#define omsImageInfo_HEADER 1

#include <vector>
#include <string>
#include <oms/Constants.h>
#include <oms/Object.h>
#include <ossim/base/ossimGpt.h>

class ossimImageGeometry;
class ossimImageHandler;

namespace oms
{
   class  DataInfoPrivateData;
   class OMSDLL DataInfo : public oms::Object
   {
   public:
      /** default constructor */
      DataInfo();
   
      /** destructor */
      virtual ~DataInfo();


      /**
       * @brief Open method.
       * @param file File to open.
       * @return true on success, false on error.
       */
      bool open(const std::string& file, bool failIfNoGeometryFlag=true);
      bool setHandler(ossimImageHandler* handler, bool failIfNoGeometryFlag=true);
      void close();
      bool isVideo()const;
      bool isImagery()const;
      std::string getInfo()const;
      std::string getImageInfo(int entry=-1);
      std::string getVideoInfo();

      bool getGroundCorners(std::vector<ossimGpt>& corners, int entry=-1);
      double getMetersPerPixel(int entry=-1, int resolution = 0);
      int getNumberOfEntries()const;
      int getNumberOfResolutionLevels(int entry)const;
      void getWidthHeight(int entry, int resolution, int* w, int* h)const;

      static std::string readInfo(const std::string& file, bool failIfNoGeometryFlag=true);
      
   private:
      std::string convertIdatimToXmlDate(const std::string& idatim)const;
      std::string convertAcqDateToXmlDate(const std::string& idatim)const;
      std::string checkAndGetThumbnail(const std::string& baseName)const;

      void appendRasterEntry(std::string& outputString,
                             const std::string& indentation,
                             const std::string& separator)const;
      void appendRasterEntries(std::string& outputString,
                               const std::string& indentation,
                               const std::string& separator)const;

      /**
       * @brief Appends non ossim generated associate files to <fileObjects> as
       * <RasterFile> tags.
       * @param outputString Initialized by this.
       * @param indentation e.g. "      "
       * @param separator e.g. "\n"
       */
      void appendAssociatedFiles(std::string& outputString,
                                 const std::string& indentation,
                                 const std::string& separator)const;
      
      void appendAssociatedRasterEntryFileObjects(std::string& outputString,
                                                  const std::string& indentation,
                                                  const std::string& separator)const;
      void appendBitDepthAndDataType(std::string& outputString,
                                     const std::string& indentation,
                                     const std::string& separator)const;
      void appendGeometryInformation(std::string& outputString,
                                     const std::string& indentation,
                                     const std::string& separator)const;
      void appendRasterDataSetMetadata(std::string& outputString,
                                       const std::string& indentation,
                                       const std::string& separator)const;
      void appendVideoDataSetMetadata(std::string& outputString,
                                       const std::string& indentation,
                                       const std::string& separator)const;
      void appendRasterEntryDateTime(std::string& outputString,
                                     const std::string& indentation,
                                     const std::string& separator)const;
      void appendRasterEntryMetadata(std::string& outputString,
                                     const std::string& indentation,
                                     const std::string& separator)const;

      /**
       * @brief Gets a wkt polygon from "wkt_footprint" key in geometry if
       * found.
       * @param geom Pointer to image geometry.
       * @param s Initialized by this.
       */
      bool getWktFootprint( const ossimImageGeometry* geom, std::string& s ) const;
      
      DataInfoPrivateData* thePrivateData;
    };

} // end of namespace oms

#endif /* End of #ifndef omsImageInfo_HEADER */
