/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.devstudio;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.antcontrib.cpptasks.CCTask;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.TargetInfo;
import net.sf.antcontrib.cpptasks.compiler.CommandLineCompilerConfiguration;
import net.sf.antcontrib.cpptasks.compiler.CommandLineLinkerConfiguration;
import net.sf.antcontrib.cpptasks.compiler.ProcessorConfiguration;
import net.sf.antcontrib.cpptasks.devstudio.DevStudioCCompiler;
import net.sf.antcontrib.cpptasks.devstudio.DevStudioCompatibleLinker;
import net.sf.antcontrib.cpptasks.ide.ProjectDef;
import net.sf.antcontrib.cpptasks.ide.ProjectWriter;
import org.apache.tools.ant.BuildException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class VisualStudioNETProjectWriter
implements ProjectWriter {
    private final String version;
    private final String trueLiteral;
    private final String falseLiteral;

    public VisualStudioNETProjectWriter(String versionArg, String trueArg, String falseArg) {
        if (versionArg == null) {
            throw new IllegalArgumentException("versionArg");
        }
        if (trueArg == null) {
            throw new IllegalArgumentException("trueArg");
        }
        if (falseArg == null) {
            throw new IllegalArgumentException("falseArg");
        }
        this.version = versionArg;
        this.trueLiteral = trueArg;
        this.falseLiteral = falseArg;
    }

    private String getConfigurationName(CCTask task) {
        if (task.getDebug()) {
            return "Debug|Win32";
        }
        return "Release|Win32";
    }

    private String getConfigurationType(CCTask task) {
        String outputType = task.getOuttype();
        String targtype = "2";
        if ("executable".equals(outputType)) {
            targtype = "1";
        } else if ("static".equals(outputType)) {
            targtype = "4";
        }
        return targtype;
    }

    private String getOutputDirectory(String basePath, CCTask task) {
        File outFile = task.getOutfile();
        File buildDir = outFile.getParentFile();
        return CUtil.getRelativePath(basePath, buildDir);
    }

    private String getIntermediateDirectory(String basePath, CCTask task) {
        File objDir = task.getObjdir();
        return CUtil.getRelativePath(basePath, objDir);
    }

    private String getCharacterSet(CommandLineCompilerConfiguration compilerConfig) {
        String[] args = compilerConfig.getPreArguments();
        String charset = "0";
        for (int i = 0; i < args.length; ++i) {
            if ("/D_UNICODE".equals(args[i]) || "/DUNICODE".equals(args[i])) {
                charset = "1";
            }
            if (!"/D_MBCS".equals(args[i])) continue;
            charset = "2";
        }
        return charset;
    }

    private void writeConfigurationStartTag(ContentHandler content, String basePath, CCTask task, CommandLineCompilerConfiguration compilerConfig) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        VisualStudioNETProjectWriter.addAttribute(attributes, "Name", this.getConfigurationName(task));
        VisualStudioNETProjectWriter.addAttribute(attributes, "OutputDirectory", this.getOutputDirectory(basePath, task));
        VisualStudioNETProjectWriter.addAttribute(attributes, "IntermediateDirectory", this.getIntermediateDirectory(basePath, task));
        VisualStudioNETProjectWriter.addAttribute(attributes, "ConfigurationType", this.getConfigurationType(task));
        VisualStudioNETProjectWriter.addAttribute(attributes, "CharacterSet", this.getCharacterSet(compilerConfig));
        content.startElement(null, "Configuration", "Configuration", attributes);
    }

    private String getOptimization(CommandLineCompilerConfiguration compilerConfig) {
        String[] args = compilerConfig.getPreArguments();
        String opt = "0";
        for (int i = 0; i < args.length; ++i) {
            if ("/Od".equals(args[i])) {
                opt = "0";
            }
            if ("/O1".equals(args[i])) {
                opt = "1";
            }
            if ("/O2".equals(args[i])) {
                opt = "2";
            }
            if (!"/Ox".equals(args[i])) continue;
            opt = "3";
        }
        return opt;
    }

    private String getAdditionalIncludeDirectories(CommandLineCompilerConfiguration compilerConfig) {
        StringBuffer includeDirs = new StringBuffer();
        String[] args = compilerConfig.getPreArguments();
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("/I")) continue;
            includeDirs.append(args[i].substring(2));
            includeDirs.append(';');
        }
        if (includeDirs.length() > 0) {
            includeDirs.setLength(includeDirs.length() - 1);
        }
        return includeDirs.toString();
    }

    private String getPreprocessorDefinitions(CommandLineCompilerConfiguration compilerConfig) {
        StringBuffer defines = new StringBuffer();
        String[] args = compilerConfig.getPreArguments();
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("/D")) continue;
            defines.append(args[i].substring(2));
            defines.append(";");
        }
        if (defines.length() > 0) {
            defines.setLength(defines.length() - 1);
        }
        return defines.toString();
    }

    private String getRuntimeLibrary(CommandLineCompilerConfiguration compilerConfig) {
        String rtl = null;
        String[] args = compilerConfig.getPreArguments();
        for (int i = 0; i < args.length; ++i) {
            if ("/MT".equals(args[i])) {
                rtl = "0";
            }
            if ("/MTd".equals(args[i])) {
                rtl = "1";
            }
            if ("/MD".equals(args[i])) {
                rtl = "2";
            }
            if (!"/MDd".equals(args[i])) continue;
            rtl = "3";
        }
        return rtl;
    }

    private String getUsePrecompiledHeader(CommandLineCompilerConfiguration compilerConfig) {
        String usePCH = "0";
        String[] args = compilerConfig.getPreArguments();
        for (int i = 0; i < args.length; ++i) {
            if ("/Yc".equals(args[i])) {
                usePCH = "1";
            }
            if (!"/Yu".equals(args[i])) continue;
            usePCH = "2";
        }
        return usePCH;
    }

    private String getPrecompiledHeaderFile(CommandLineCompilerConfiguration compilerConfig) {
        String pch = null;
        String[] args = compilerConfig.getPreArguments();
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("/Fp")) continue;
            pch = args[i].substring(3);
        }
        return pch;
    }

    private String getMinimalRebuild(CommandLineCompilerConfiguration compilerConfig) {
        return this.trueLiteral;
    }

    private String getBasicRuntimeChecks(CommandLineCompilerConfiguration compilerConfig) {
        String checks = "0";
        String[] args = compilerConfig.getPreArguments();
        for (int i = 0; i < args.length; ++i) {
            if ("/RTCs".equals(args[i])) {
                checks = "1";
            }
            if ("/RTCu".equals(args[i])) {
                checks = "2";
            }
            if (!"/RTC1".equals(args[i]) && !"/GZ".equals(args[i])) continue;
            checks = "3";
        }
        return checks;
    }

    private String getWarningLevel(CommandLineCompilerConfiguration compilerConfig) {
        String warn = null;
        String[] args = compilerConfig.getPreArguments();
        for (int i = 0; i < args.length; ++i) {
            if ("/W0".equals(args[i])) {
                warn = "0";
            }
            if ("/W1".equals(args[i])) {
                warn = "1";
            }
            if ("/W2".equals(args[i])) {
                warn = "2";
            }
            if (!"/W3".equals(args[i])) continue;
            warn = "3";
        }
        return warn;
    }

    private String getDetect64BitPortabilityProblems(CommandLineCompilerConfiguration compilerConfig) {
        String warn64 = null;
        String[] args = compilerConfig.getPreArguments();
        for (int i = 0; i < args.length; ++i) {
            if (!"/Wp64".equals(args[i])) continue;
            warn64 = this.trueLiteral;
        }
        return warn64;
    }

    private String getDebugInformationFormat(CommandLineCompilerConfiguration compilerConfig) {
        String format = "0";
        String[] args = compilerConfig.getPreArguments();
        for (int i = 0; i < args.length; ++i) {
            if ("/Z7".equals(args[i])) {
                format = "1";
            }
            if ("/Zi".equals(args[i])) {
                format = "3";
            }
            if (!"/ZI".equals(args[i])) continue;
            format = "4";
        }
        return format;
    }

    private void writeCompilerElement(ContentHandler content, CommandLineCompilerConfiguration compilerConfig) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        VisualStudioNETProjectWriter.addAttribute(attributes, "Name", "VCCLCompilerTool");
        VisualStudioNETProjectWriter.addAttribute(attributes, "Optimization", this.getOptimization(compilerConfig));
        VisualStudioNETProjectWriter.addAttribute(attributes, "AdditionalIncludeDirectories", this.getAdditionalIncludeDirectories(compilerConfig));
        VisualStudioNETProjectWriter.addAttribute(attributes, "PreprocessorDefinitions", this.getPreprocessorDefinitions(compilerConfig));
        VisualStudioNETProjectWriter.addAttribute(attributes, "MinimalRebuild", this.getMinimalRebuild(compilerConfig));
        VisualStudioNETProjectWriter.addAttribute(attributes, "BasicRuntimeChecks", this.getBasicRuntimeChecks(compilerConfig));
        VisualStudioNETProjectWriter.addAttribute(attributes, "RuntimeLibrary", this.getRuntimeLibrary(compilerConfig));
        VisualStudioNETProjectWriter.addAttribute(attributes, "UsePrecompiledHeader", this.getUsePrecompiledHeader(compilerConfig));
        VisualStudioNETProjectWriter.addAttribute(attributes, "PrecompiledHeaderFile", this.getPrecompiledHeaderFile(compilerConfig));
        VisualStudioNETProjectWriter.addAttribute(attributes, "WarningLevel", this.getWarningLevel(compilerConfig));
        VisualStudioNETProjectWriter.addAttribute(attributes, "Detect64BitPortabilityProblems", this.getDetect64BitPortabilityProblems(compilerConfig));
        VisualStudioNETProjectWriter.addAttribute(attributes, "DebugInformationFormat", this.getDebugInformationFormat(compilerConfig));
        content.startElement(null, "Tool", "Tool", attributes);
        content.endElement(null, "Tool", "Tool");
    }

    private String getLinkIncremental(CommandLineLinkerConfiguration linkerConfig) {
        String incremental = "0";
        String[] args = linkerConfig.getPreArguments();
        for (int i = 0; i < args.length; ++i) {
            if ("/INCREMENTAL:NO".equals(args[i])) {
                incremental = "1";
            }
            if (!"/INCREMENTAL:YES".equals(args[i])) continue;
            incremental = "2";
        }
        return incremental;
    }

    private String getGenerateDebugInformation(CommandLineLinkerConfiguration linkerConfig) {
        String debug = this.falseLiteral;
        String[] args = linkerConfig.getPreArguments();
        for (int i = 0; i < args.length; ++i) {
            if (!"/DEBUG".equals(args[i])) continue;
            debug = this.trueLiteral;
        }
        return debug;
    }

    private String getSubsystem(CommandLineLinkerConfiguration linkerConfig) {
        String subsystem = "0";
        String[] args = linkerConfig.getPreArguments();
        for (int i = 0; i < args.length; ++i) {
            if ("/SUBSYSTEM:CONSOLE".equals(args[i])) {
                subsystem = "1";
            }
            if ("/SUBSYSTEM:WINDOWS".equals(args[i])) {
                subsystem = "2";
            }
            if (!"/SUBSYSTEM:WINDOWSCE".equals(args[i])) continue;
            subsystem = "9";
        }
        return subsystem;
    }

    private String getTargetMachine(CommandLineLinkerConfiguration linkerConfig) {
        String subsystem = "0";
        String[] args = linkerConfig.getPreArguments();
        for (int i = 0; i < args.length; ++i) {
            if (!"/MACHINE:X86".equals(args[i])) continue;
            subsystem = "1";
        }
        return subsystem;
    }

    private String getAdditionalDependencies(TargetInfo linkTarget, Map targets, String basePath) {
        String dependencies = null;
        File[] linkSources = linkTarget.getAllSources();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < linkSources.length; ++i) {
            if (targets.get(linkSources[i].getName()) != null) continue;
            String relPath = CUtil.getRelativePath(basePath, linkSources[i]);
            if (relPath.indexOf(32) > 0) {
                buf.append('\"');
                buf.append(relPath);
                buf.append('\"');
            } else {
                buf.append(relPath);
            }
            buf.append(';');
        }
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 1);
            dependencies = buf.toString();
        }
        return dependencies;
    }

    private void writeLinkerElement(ContentHandler content, String basePath, TargetInfo linkTarget, Map targets) throws SAXException {
        CommandLineLinkerConfiguration linkerConfig;
        AttributesImpl attributes = new AttributesImpl();
        VisualStudioNETProjectWriter.addAttribute(attributes, "Name", "VCLinkerTool");
        ProcessorConfiguration config = linkTarget.getConfiguration();
        if (config instanceof CommandLineLinkerConfiguration && (linkerConfig = (CommandLineLinkerConfiguration)config).getLinker() instanceof DevStudioCompatibleLinker) {
            VisualStudioNETProjectWriter.addAttribute(attributes, "LinkIncremental", this.getLinkIncremental(linkerConfig));
            VisualStudioNETProjectWriter.addAttribute(attributes, "GenerateDebugInformation", this.getGenerateDebugInformation(linkerConfig));
            VisualStudioNETProjectWriter.addAttribute(attributes, "SubSystem", this.getSubsystem(linkerConfig));
            VisualStudioNETProjectWriter.addAttribute(attributes, "TargetMachine", this.getTargetMachine(linkerConfig));
        }
        VisualStudioNETProjectWriter.addAttribute(attributes, "AdditionalDependencies", this.getAdditionalDependencies(linkTarget, targets, basePath));
        content.startElement(null, "Tool", "Tool", attributes);
        content.endElement(null, "Tool", "Tool");
    }

    public void writeProject(File fileName, CCTask task, ProjectDef projectDef, List sources, Hashtable targets, TargetInfo linkTarget) throws IOException, SAXException {
        String projectName = projectDef.getName();
        if (projectName == null) {
            projectName = fileName.getName();
        }
        File vcprojFile = new File(fileName + ".vcproj");
        if (!projectDef.getOverwrite() && vcprojFile.exists()) {
            throw new BuildException("Not allowed to overwrite project file " + vcprojFile.toString());
        }
        File slnFile = new File(fileName + ".sln");
        if (!projectDef.getOverwrite() && slnFile.exists()) {
            throw new BuildException("Not allowed to overwrite project file " + slnFile.toString());
        }
        CommandLineCompilerConfiguration compilerConfig = this.getBaseCompilerConfiguration(targets);
        if (compilerConfig == null) {
            throw new BuildException("Unable to generate Visual Studio.NET project when Microsoft C++ is not used.");
        }
        FileOutputStream outStream = new FileOutputStream(fileName + ".vcproj");
        OutputFormat format = new OutputFormat("xml", "UTF-8", true);
        XMLSerializer serializer = new XMLSerializer((OutputStream)outStream, format);
        ContentHandler content = serializer.asContentHandler();
        String basePath = fileName.getParentFile().getAbsolutePath();
        content.startDocument();
        AttributesImpl emptyAttrs = new AttributesImpl();
        AttributesImpl attributes = new AttributesImpl();
        VisualStudioNETProjectWriter.addAttribute(attributes, "ProjectType", "Visual C++");
        VisualStudioNETProjectWriter.addAttribute(attributes, "Version", this.version);
        VisualStudioNETProjectWriter.addAttribute(attributes, "Name", projectName);
        content.startElement(null, "VisualStudioProject", "VisualStudioProject", attributes);
        content.startElement(null, "Platforms", "Platforms", emptyAttrs);
        attributes.clear();
        VisualStudioNETProjectWriter.addAttribute(attributes, "Name", "Win32");
        content.startElement(null, "Platform", "Platform", attributes);
        content.endElement(null, "Platform", "Platform");
        content.endElement(null, "Platforms", "Platforms");
        content.startElement(null, "Configurations", "Configurations", emptyAttrs);
        this.writeConfigurationStartTag(content, basePath, task, compilerConfig);
        this.writeCompilerElement(content, compilerConfig);
        this.writeLinkerElement(content, basePath, linkTarget, targets);
        content.endElement(null, "Configuration", "Configuration");
        content.endElement(null, "Configurations", "Configurations");
        content.startElement(null, "References", "References", emptyAttrs);
        content.endElement(null, "References", "References");
        content.startElement(null, "Files", "Files", emptyAttrs);
        File[] sortedSources = new File[sources.size()];
        sources.toArray(sortedSources);
        Arrays.sort(sortedSources, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((File)o1).getName().compareTo(((File)o2).getName());
            }
        });
        this.writeFilteredSources("Source Files", "cpp;c;cxx;def;odl;idl;hpj;bat;asm;asmx", basePath, sortedSources, content);
        this.writeFilteredSources("Header Files", "h;hpp;hxx;hm;inl;inc;xsd", basePath, sortedSources, content);
        this.writeFilteredSources("Resource Files", "rc;ico;cur;bmp;dlg;rc2;rct;bin;rgs;gif;jpg;jpeg;jpe;resx", basePath, sortedSources, content);
        content.endElement(null, "Files", "Files");
        content.startElement(null, "Globals", "Globals", emptyAttrs);
        content.endElement(null, "Globals", "Globals");
        content.endElement(null, "VisualStudioProject", "VisualStudioProject");
        content.endDocument();
    }

    private void writeFilteredSources(String name, String filter, String basePath, File[] sortedSources, ContentHandler content) throws SAXException {
        AttributesImpl filterAttrs = new AttributesImpl();
        filterAttrs.addAttribute(null, "Name", "Name", "#PCDATA", name);
        filterAttrs.addAttribute(null, "Filter", "Filter", "#PCDATA", filter);
        content.startElement(null, "Filter", "Filter", filterAttrs);
        AttributesImpl fileAttrs = new AttributesImpl();
        fileAttrs.addAttribute(null, "RelativePath", "RelativePath", "#PCDATA", "");
        for (int i = 0; i < sortedSources.length; ++i) {
            if (!this.isGroupMember(filter, sortedSources[i])) continue;
            String relativePath = CUtil.getRelativePath(basePath, sortedSources[i]);
            fileAttrs.setValue(0, relativePath);
            content.startElement(null, "File", "File", fileAttrs);
            content.endElement(null, "File", "File");
        }
        content.endElement(null, "Filter", "Filter");
    }

    private boolean isGroupMember(String filter, File candidate) {
        String fileName = candidate.getName();
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot >= 0 && lastDot < fileName.length() - 1) {
            String extension = ";" + fileName.substring(lastDot + 1).toLowerCase() + ";";
            String semiFilter = ";" + filter + ";";
            return semiFilter.indexOf(extension) >= 0;
        }
        return false;
    }

    private static void addAttribute(AttributesImpl attributes, String attrName, String attrValue) {
        if (attrName == null) {
            throw new IllegalArgumentException("attrName");
        }
        if (attrValue != null) {
            attributes.addAttribute(null, attrName, attrName, "#PCDATA", attrValue);
        }
    }

    private CommandLineCompilerConfiguration getBaseCompilerConfiguration(Hashtable targets) {
        Iterator targetIter = targets.values().iterator();
        while (targetIter.hasNext()) {
            CommandLineCompilerConfiguration compilerConfig;
            TargetInfo targetInfo = (TargetInfo)targetIter.next();
            ProcessorConfiguration config = targetInfo.getConfiguration();
            if (!(config instanceof CommandLineCompilerConfiguration) || !((compilerConfig = (CommandLineCompilerConfiguration)config).getCompiler() instanceof DevStudioCCompiler)) continue;
            return compilerConfig;
        }
        return null;
    }
}

