/********************************************************************** * 
 * @project Fusion
 * @revision $Id: FitToWindow.js,v 1.14 2007/06/29 14:49:06 pspencer Exp $
 * @purpose Fit to window (full extents)
 * @author yassefa@dmsolutions.ca
 * Copyright (c) 2007 DM Solutions Group Inc.
 *****************************************************************************
 * This code shall not be copied or used without the expressed written consent
 * of DM Solutions Group Inc.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * 
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 ********************************************************************
 *
 * Fit to window (full extent) widget using the map guide web layout configuration file
 * 
 * **********************************************************************/



Fusion.Widget.FitToWindow = Class.create();
Fusion.Widget.FitToWindow.prototype = {
    initialize : function(oCommand) {
        //console.log('FitToWindow.initialize');
        Object.inheritFrom(this, Fusion.Widget.prototype, ['FitToWindow', false, oCommand]);
        Object.inheritFrom(this, Fusion.Tool.ButtonBase.prototype, []);
        this.setMap(oCommand.getMap());
    },

    execute: function() {
        //console.log('FitToWindow.activateTool');
        this.getMap().fullExtents();
    }
};
