//  Copyright (C) 2004-2007 by Autodesk, Inc.
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of version 2.1 of the GNU Lesser
//  General Public License as published by the Free Software Foundation.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using OSGeo.MapGuide;
using System.Collections.Specialized;
using System.Text.RegularExpressions;

public partial class working_with_feature_data_selectfeatures : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {

        NameValueCollection requestParams = Request.HttpMethod == "GET" ? Request.QueryString : Request.Form;
        String mgSessionId = requestParams["SESSION"];
        String mgLocale = requestParams["LOCALE"];
        String mgMapName = requestParams["MAPNAME"];

        // Initialize the web-tier.
        String realPath = Request.ServerVariables["APPL_PHYSICAL_PATH"];
        String configPath = realPath + "..\\webconfig.ini";
        MapGuideApi.MgInitializeWebTier(configPath);

        // Connect to the site.
        MgUserInformation userInfo = new MgUserInformation(mgSessionId);
        MgSiteConnection siteConnection = new MgSiteConnection();
        siteConnection.Open(userInfo);

        // get the map
        MgMap map = new MgMap(siteConnection);
        map.Open(mgMapName);

        // get the geometry for the boundaries of District 1

        MgFeatureQueryOptions districtQuery = new MgFeatureQueryOptions();
        districtQuery.SetFilter("Autogenerated_SDF_ID = 1");

        MgLayer layer = map.GetLayers().GetItem("Districts") as MgLayer;
        MgFeatureReader featureReader = layer.SelectFeatures(districtQuery);
        featureReader.ReadNext();
        MgByteReader districtGeometryData = featureReader.GetGeometry("Data");

        // Convert the AGF binary data to MgGeometry.

        MgAgfReaderWriter agfReaderWriter = new MgAgfReaderWriter();
        MgGeometry districtGeometry = agfReaderWriter.Read(districtGeometryData);

        // Create a filter to select the desired features. Combine
        // a basic filter and a spatial filter.

        MgFeatureQueryOptions queryOptions = new MgFeatureQueryOptions();
        queryOptions.SetFilter("RNAME LIKE 'SCHMITT%'");

        queryOptions.SetSpatialFilter(
            "SHPGEOM",
            districtGeometry,
            MgFeatureSpatialOperations.Inside);

        // Get the features from the feature source,
        // turn it into a selection, then save the selection as XML.

        layer = map.GetLayers().GetItem("Parcels") as MgLayer;
        featureReader = layer.SelectFeatures(queryOptions);

        layer = map.GetLayers().GetItem("Parcels") as MgLayer;
        MgSelection selection = new MgSelection(map);
        selection.AddFeatures(layer, featureReader, 0);
        String selectionXml = selection.ToXml();

        litSelectionXml.Text = Server.HtmlEncode(selectionXml);

        hfSelectionXml.Value = selectionXml;

    }
}
