<!--
//  Copyright (C) 2004-2007 by Autodesk, Inc.
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of version 2.1 of the GNU Lesser
//  General Public License as published by the Free Software Foundation.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
-->

<%@ Page Language="C#" AutoEventWireup="true" CodeFile="selectfeatures.aspx.cs" 
Inherits="working_with_feature_data_selectfeatures" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" 
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head runat="server">
    <title>Select Features</title>
    <meta content="text/html; charset=utf-8" http-equiv="Content-Type" />
    <meta http-equiv="content-style-type" content="text/css" />
    <link href="../styles/dotnetsamples.css" rel="stylesheet" type="text/css"/>
    <meta http-equiv="content-script-type" content="text/javascript" />
    
    <script type="text/javascript">

    // Emit the following function and assocate it with the onLoad event for 
    // the page so that it gets executed when this page loads in the browser.       
    // The function calls the SetSelectionXML method on the Viewer Frame, 
    // which updates the current selection on the viewer and the server.
                                                     
    function OnPageLoad()
    {
    
        var selectionXml = document.getElementById("hfSelectionXml").getAttribute("value");
        
        parent.parent.SetSelectionXML(selectionXml);
        
    }

    </script>
  
</head>
<body onload="OnPageLoad()">

    <form id="form1" runat="server">
    <div>
    
    <h1>Select Features</h1>
    
    <p>Selecting parcels owned by people named Schmitt in District 1.</p>
    
    <p>Here's what the selection XML looks like (scroll right to see it all):</p>
    
<pre class="small">
<asp:Literal id="litSelectionXml" Text="" runat="server" />
</pre>

    <p>When the selection appears, hover over selected parcels to see the 
    owner's full name and the street address.</p>
    
    <!-- store selection xml for js function OnPageLoad() -->
    <asp:HiddenField ID="hfSelectionXml" runat="server"></asp:HiddenField>
    
    </div>
    </form>
        
</body>
</html>
