//  Copyright (C) 2004-2007 by Autodesk, Inc.
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of version 2.1 of the GNU Lesser
//  General Public License as published by the Free Software Foundation.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using OSGeo.MapGuide;
using System.Collections.Specialized;


public partial class interacting_with_layers_toggle_layer_label : System.Web.UI.Page
{

    protected void Page_Load(object sender, EventArgs e)
    {

        NameValueCollection requestParams = Request.HttpMethod == "GET" ? Request.QueryString : Request.Form;
        String mgSessionId = requestParams["SESSION"];
        String mgLocale = requestParams["LOCALE"];
        String mgMapName = requestParams["MAPNAME"];

        // Initialize the web-tier.
        String realPath = Request.ServerVariables["APPL_PHYSICAL_PATH"];
        String configPath = realPath + "..\\webconfig.ini";
        MapGuideApi.MgInitializeWebTier(configPath);

        // Connect to the site.
        MgUserInformation userInfo = new MgUserInformation(mgSessionId);
        MgSiteConnection siteConnection = new MgSiteConnection();
        siteConnection.Open(userInfo);

        // Get an instance of the required service(s).
        MgResourceService resourceService = siteConnection.CreateService(MgServiceType.ResourceService) as MgResourceService;

        // Get the current map.
        MgMap map = new MgMap();
        map.Open(resourceService, mgMapName);

        // Get map layers.
        MgLayerCollection mgLayers = map.GetLayers();

        MgLayer roadsLayer = mgLayers.GetItem("Roads") as MgLayer;
        String roadsLayerLabel = roadsLayer.LegendLabel;
        String newRoadsLayerLabel;

        if (roadsLayerLabel == "Roads")
        {
            newRoadsLayerLabel = "Streets";
        }
        else
        {
            newRoadsLayerLabel = "Roads";
        }

        roadsLayer.LegendLabel = newRoadsLayerLabel;

        // Save the updated map to apply the change
        map.Save(resourceService);

        labOldName.Text = roadsLayerLabel;
        labNewName.Text = roadsLayer.LegendLabel;

    }
    
}
