<!--
//  Copyright (C) 2004-2007 by Autodesk, Inc.
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of version 2.1 of the GNU Lesser
//  General Public License as published by the Free Software Foundation.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
-->

<%@ Page language="c#" %>
<%@ Import Namespace="OSGeo.MapGuide" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" 
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" >
<head runat="server">

<title>Samples Overview</title>
<meta content="text/html; charset=utf-8" http-equiv="Content-Type" />
<meta http-equiv="content-style-type" content="text/css" />
<link href="styles/dotnetsamples.css" rel="stylesheet" type="text/css"/>
<meta http-equiv="content-script-type" content="text/javascript" />
<script src="common/pageLoadFunctions.js" type="text/javascript" language="JavaScript">
</script>

</head>

<body>

<%

NameValueCollection serverVars = Request.ServerVariables;
String strServerVars = "";
foreach (String str in serverVars.AllKeys)
{

    strServerVars += "<br>" + str;

}
String platform = serverVars["SERVER_SOFTWARE"];
String queryStr = serverVars["QUERY_STRING"];

NameValueCollection requestParams = Request.HttpMethod == "GET" ? Request.QueryString : Request.Form;
String strRequestParams = "";
foreach (String str in requestParams.AllKeys)
{

    strRequestParams += "<br>" + str;

}
String mgSessionId = requestParams["SESSION"];
String mgLayout = requestParams["LAYOUT"];
String mgLocale = requestParams["LOCALE"];

// Note that MAPNAME is not passed - this page is passed only
// SESSION, LAYOUT, AND LOCALE, so we set mgMapName explicitly
String mgMapName = "Sheboygan";

// Initialize Web Extensions.
String realPath = Request.ServerVariables["APPL_PHYSICAL_PATH"];
String configPath = realPath + "..\\webconfig.ini";
MapGuideApi.MgInitializeWebTier(configPath);

// Connect to the site.
MgUserInformation userInfo = new MgUserInformation(mgSessionId);
MgSiteConnection siteConnection = new MgSiteConnection();
siteConnection.Open(userInfo);


// For viewing source.
String sourceFile;
String sourcePath;

// view index (this task pane) source
sourceFile = Server.UrlEncode(Server.MapPath("index.aspx"));
hypViewIndex.NavigateUrl = "common/viewsource.aspx" + 
"?FILENAME=" + sourceFile;

// view main (the surrounding frameset) source
sourceFile = Server.UrlEncode(Server.MapPath("main.aspx"));
hypViewMain.NavigateUrl = "common/viewsource.aspx" + 
"?FILENAME=" + sourceFile;

%>

<p>At any time, click <img class="inline-icon" alt="" src="../stdicons/icon_home.gif" width="16" height="16" /> 
in the task bar to return to this list of samples.</p>

<h2>Basic Samples</h1>

<ul>

<li><a href="hello_map/task_pane.aspx?SESSION=<%=mgSessionId%>&LOCALE=<%=mgLocale%>&MAPNAME=<%=mgMapName%>">
Hello Map</a></li>

<li><a href="hello_viewer/task_pane.aspx?SESSION=<%=mgSessionId%>&LOCALE=<%=mgLocale%>&MAPNAME=<%=mgMapName%>">
Hello Viewer</a></li>

<li><a href="interacting_with_layers/task_pane.aspx?SESSION=<%=mgSessionId%>&LOCALE=<%=mgLocale%>&MAPNAME=<%=mgMapName%>">
Interacting With Layers</a></li>

<li><a href="working_with_feature_data/task_pane.aspx?SESSION=<%=mgSessionId%>&LOCALE=<%=mgLocale%>&MAPNAME=<%=mgMapName%>">
Working With Feature Data</a></li>

</ul>

<h2>Viewer Samples</h1>

<ul>

<li><a href="../dotnetviewersample/dwfviewersample.aspx?SESSION=<%=mgSessionId%>&LOCALE=<%=mgLocale%>&MAPNAME=<%=mgMapName%>" target="_blank">
Using DWF Viewer</a></li>

<li><a href="../dotnetviewersample/ajaxviewersample.aspx?SESSION=<%=mgSessionId%>&LOCALE=<%=mgLocale%>&MAPNAME=<%=mgMapName%>" target="_blank">
Using Ajax Viewer</a></li>

<li><a href="../dotnetviewersample/ajaxtiledviewersample.aspx?SESSION=<%=mgSessionId%>&LOCALE=<%=mgLocale%>&MAPNAME=<%=mgMapName%>" target="_blank">
Using Tiled Ajax Viewer</a></li>

</ul>

<h2>Documentation</h1>

<p>Documentation opens in a new window.</p>

<ul>
<li><a href="../help/DevGuide.pdf" target="_blank">Developer's Guide</a></li>
<li><a href="../help/index.htm" target="_blank">Web Server Extensions API Reference</a></li>
<li><a href="../help/viewerapi.html" target="_blank">Viewer API Reference</a></li>
</ul>

<p>If these documentation links are not working, you can <nobr><a href="common\fixing_the_documentation_links.html">fix them</a></nobr>.</p>

<h2>View Source</h1>

<p>Source files open in a new window.</p>

<ul>

<!-- view index (this task pane) source -->
<li>
<asp:HyperLink ID="hypViewIndex" runat="server" Target="_blank">
This task pane</asp:HyperLink>.</li>

<!-- view main (surrounding frameset) source -->
<li>This task pane's 
<asp:HyperLink ID="hypViewMain" runat="server" Target="_blank">
surrounding frameset</asp:HyperLink>.</li>

<li class="li-comment">
The surrounding frameset defines the title frame (which includes the title and head graphic), and the viewer frame (which includes the map features list, the map itself, and this task pane).</li>

</ul>

<h2>FYI</h1>

<p>Web Server: <span class="data-value"><%=platform%></span></p>

</body>
</html>
