<%@ Page Language="C#" AutoEventWireup="true" CodeFile="task_pane.aspx.cs" 
Inherits="hello_viewer_task_pane" %>
<%@ Import Namespace="OSGeo.MapGuide" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" 
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head runat="server">
    <title>Hello Viewer</title>
    <meta content="text/html; charset=utf-8" http-equiv="Content-Type"/>
    <meta http-equiv="content-style-type" content="text/css"/>
    <link href="../styles/dotnetsamples.css" rel="stylesheet" type="text/css"/>
    <meta http-equiv="content-script-type" content="text/javascript"/>
</head>
<body>

    <form id="form1" runat="server">
    
    <%
    
    NameValueCollection serverVars = Request.ServerVariables;
    String platform = serverVars["SERVER_SOFTWARE"];
    String queryStr = serverVars["QUERY_STRING"];

    NameValueCollection requestParams = Request.HttpMethod == "GET" ? Request.QueryString : Request.Form;
    String mgSessionId = requestParams["SESSION"];
    String mgLocale = requestParams["LOCALE"];
    String mgMapName = requestParams["MAPNAME"];

    // Initialize the web-tier.
    String realPath = Request.ServerVariables["APPL_PHYSICAL_PATH"];
    String configPath = realPath + "..\\webconfig.ini";
    MapGuideApi.MgInitializeWebTier(configPath);

    // Connect to the site.
    MgUserInformation userInfo = new MgUserInformation(mgSessionId);
    MgSiteConnection siteConnection = new MgSiteConnection();
    siteConnection.Open(userInfo);

    %>
    
    <div>
    
    <h1>Hello Viewer</h1>
        
    <p>This sample shows four ways of calling MapGuide Viewer API functions.</p>
    
    <h2>One</h2>

	<p>The web layout contains a custom Invoke Script 
    command that calls the <code>ZoomToView</code> function.</p>
    
    <p>Click the 
    <img alt="" src="../../stdicons/icon_invokescript.gif" width="16" height="16" /> 
    button in the tool bar, task list, or context menu to reposition the map 
    view. The Invoke Script command is defined in the web layout for the sample. 
    It makes the following function call (scroll to the 
	right to see it all):</p>
    
<pre class="small">
ZoomToView(-87.732492, 43.743934, 5000, true);
</pre>

    <p>Back to the 
    <a href="#" onclick="parent.parent.ZoomToView(-87.730332, 43.744200, 65181, true);">
    original view</a>.</p>
    
    <h2>Two</h2>

	<p>Click 
    <a href="gotopoint.aspx?X=-87.724520&Y=43.768387&Scale=5000" target="scriptFrame">
    this link</a> to display a different view. This loads <span class="filename">
    gotopoint.aspx</span> into the hidden script frame.</p><!-- target="scriptFrame" -->

	<!-- view gotopoint source -->
	<li class="li-comment">
	View source: 
	<asp:HyperLink ID="hypViewGoToPoint" runat="server" Target="_blank">
	aspx</asp:HyperLink> 
	<asp:HyperLink ID="hypViewGoToPointCS" runat="server" Target="_blank">
	aspx.cs</asp:HyperLink>.</li>

    <p>Back to the 
    <a href="#" onclick="parent.parent.ZoomToView(-87.730332, 43.744200, 65181, true);">
    original view</a>.</p>
    
    <h2>Three</h2>

	<p>Click 
    <a href="#" onclick="parent.parent.ZoomToView(-87.707416, 43.747860, 5000, true);">
    this link</a> to display a third view. This uses <code>onclick</code> 
    in this task pane's aspx file to call JavaScript directly (scroll to the 
	right to see it all): </p>

<pre class="small">
&lt;a href="#" onclick="parent.parent.ZoomToView(-87.707416, 43.747860, 5000, true);">
</pre>

	<!-- view aspx source for this task pane -->
	<li class="li-comment">
	View aspx source for 
	<asp:HyperLink ID="hypViewThisTaskPaneAspx" runat="server" Target="_blank">
	this task pane</asp:HyperLink>.</li>

    <p>Back to the 
    <a href="#" onclick="parent.parent.ZoomToView(-87.730332, 43.744200, 65181, true);">
    original view</a>.</p>
    
    <h2>Four</h2>

	<p>
	The home task pane references a JavaScript file containing a script that 
	delays opening the home task pane until the map has opened first. The 
	purpose is to prevent communications from the task pane until the map is 
	ready to deal with them. The script does this by hooking into the 
	<code>OnMapLoaded</code> function of the viewer frame.</p>

	<p>View source for </p>

	<ul>

	<!-- view home task pane source -->
	<li>The 
	<asp:HyperLink ID="hypViewHomeTaskPane" runat="server" Target="_blank">
	home task pane</asp:HyperLink>.</li>

	<!-- view script file source -->
	<li>The 
	<asp:HyperLink ID="hypViewScript" runat="server" Target="_blank">
	script file</asp:HyperLink>.</li>

	<!-- view this task pane source -->
	<li>This task pane: 
	<asp:HyperLink ID="hypViewThisTaskPane" runat="server" Target="_blank">
	aspx</asp:HyperLink> 
	<asp:HyperLink ID="hypViewThisTaskPaneCS" runat="server" Target="_blank">
	aspx.cs</asp:HyperLink>.</li>

	</ul>
    
    </div>
    </form>

</body>
</html>
