<!--
//  Copyright (C) 2004-2007 by Autodesk, Inc.
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of version 2.1 of the GNU Lesser
//  General Public License as published by the Free Software Foundation.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
-->

<%@ Page Language="C#" AutoEventWireup="true" CodeFile="task_pane.aspx.cs" 
Inherits="hello_map_task_pane" %>
<%@ Import Namespace="OSGeo.MapGuide" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" 
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head runat="server">
    <title>Hello Map</title> 
    <meta content="text/html; charset=utf-8" http-equiv="Content-Type"/>
    <meta http-equiv="content-style-type" content="text/css"/>
    <link href="../styles/dotnetsamples.css" rel="stylesheet" type="text/css"/>
    <meta http-equiv="content-script-type" content="text/javascript"/>
</head>
<body>

    <form id="form1" runat="server">

    <%
        
    NameValueCollection serverVars = Request.ServerVariables;
    String platform = serverVars["SERVER_SOFTWARE"];
    String queryStr = serverVars["QUERY_STRING"];

    NameValueCollection requestParams = Request.HttpMethod == "GET" ? Request.QueryString : Request.Form;
    String mgSessionId = requestParams["SESSION"];
    String mgLocale = requestParams["LOCALE"];
    String mgMapName = requestParams["MAPNAME"];

    try
    {
        // Initialize the web-tier.
        String realPath = Request.ServerVariables["APPL_PHYSICAL_PATH"];
        String configPath = realPath + "..\\webconfig.ini";
        MapGuideApi.MgInitializeWebTier(configPath);

        // Connect to the site.
        MgUserInformation userInfo = new MgUserInformation(mgSessionId);
        MgSiteConnection siteConnection = new MgSiteConnection();
        siteConnection.Open(userInfo);
    }
    catch (MgException mge)
    {
        Response.Write(mge.GetMessage());
        Response.Write(mge.GetDetails());
    }

    %>

    <div>

    <h1>Hello Map</h1>

    <p>This sample shows the most basic interaction with a map. It connects to a session
    and queries information about the map.</p>

    <ul>

    <li><a href="display_spatial_reference.aspx?SESSION=<%=mgSessionId%>&LOCALE=<%=mgLocale%>&MAPNAME=<%=mgMapName%>">Display Spatial Reference</a></li>

    <li class="li-comment">Connect to MapGuide session and display basic information.</li>

	<!-- view display_spatial_reference source -->
	<li class="li-comment">
	View source: 
	<asp:HyperLink ID="hypViewDisplaySpatialReference" runat="server" Target="_blank">
	aspx</asp:HyperLink> 
	<asp:HyperLink ID="hypViewDisplaySpatialReferenceCS" runat="server" Target="_blank">
	aspx.cs</asp:HyperLink>.</li>

	</ul>

	<!-- view source for this task pane -->
	<p>View source for this task pane: 
	<asp:HyperLink ID="hypViewTaskPane" runat="server" Target="_blank">
	aspx</asp:HyperLink> 
	<asp:HyperLink ID="hypViewTaskPaneCS" runat="server" Target="_blank">
	aspx.cs</asp:HyperLink></p>

    </div>
    </form>

</body>
</html>
