﻿<!--
//  Copyright (C) 2004-2007 by Autodesk, Inc.
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of version 2.1 of the GNU Lesser
//  General Public License as published by the Free Software Foundation.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
-->

<%@ Page Language="C#" AutoEventWireup="true" CodeFile="display_spatial_reference.aspx.cs" 
Inherits="hello_map_display_spatial_reference" %>
<%@ Import Namespace="OSGeo.MapGuide" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" 
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head runat="server">
    <title>Spatial Reference</title>
    <meta content="text/html; charset=utf-8" http-equiv="Content-Type"/>
    <meta http-equiv="content-script-type" content="text/javascript"/>
    <meta http-equiv="content-style-type" content="text/css"/>
    <link href="../styles/dotnetsamples.css" rel="stylesheet" type="text/css"/>
</head>
<body>

<form id="form1" runat="server">

<%
    
NameValueCollection requestParams = Request.HttpMethod == "GET" ? Request.QueryString : Request.Form;
String mgSessionId = requestParams["SESSION"];
String mgLocale = requestParams["LOCALE"];
String mgMapName = requestParams["MAPNAME"];


// Initialize the web-tier.
string realPath = Request.ServerVariables["APPL_PHYSICAL_PATH"];
String configPath = realPath + "..\\webconfig.ini";
MapGuideApi.MgInitializeWebTier(configPath);

// connect to the site
MgUserInformation userInfo = new MgUserInformation(mgSessionId);
MgSiteConnection siteConnection = new MgSiteConnection();
siteConnection.Open(userInfo);

// get an instance of the required service
MgResourceService resourceService = siteConnection.CreateService(MgServiceType.ResourceService) as MgResourceService;

// get the current map
MgMap map = new MgMap();    
map.Open(resourceService, mgMapName);

// get the spatial reference system used for the map
String srs = map.GetMapSRS();

%>

<div>

<h1>Spatial Reference</h1>

<p>The current map, <span class="mapname"><%=mgMapName%></span>, uses the following reference system:</p>

<pre class="small"><%=srs%></pre>

<p>You have to scroll to the right to see it all.</p>

</div>
</form>

</body>
</html>
