//  Copyright (C) 2004-2007 by Autodesk, Inc.
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of version 2.1 of the GNU Lesser
//  General Public License as published by the Free Software Foundation.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using OSGeo.MapGuide;
using System.Collections.Specialized;
using System.IO;

public partial class working_with_feature_data_task_pane : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {

        NameValueCollection requestParams = Request.HttpMethod == "GET" ? Request.QueryString : Request.Form;
        String mgSessionId = requestParams["SESSION"];
        String mgLocale = requestParams["LOCALE"];
        String mgMapName = requestParams["MAPNAME"];

        // Initialize the web-tier.
        String realPath = Request.ServerVariables["APPL_PHYSICAL_PATH"];
        String configPath = realPath + "..\\webconfig.ini";
        MapGuideApi.MgInitializeWebTier(configPath);

        // Connect to the site.
        MgUserInformation userInfo = new MgUserInformation(mgSessionId);
        MgSiteConnection siteConnection = new MgSiteConnection();
        siteConnection.Open(userInfo);

        // ordinary hyperlinks

        String strDefaultParams = "?SESSION=" + mgSessionId + 
                                  "&LOCALE="  + mgLocale + 
                                  "&MAPNAME=" + mgMapName;

        hypQueryFeatures.NavigateUrl = "queryfeatures.aspx" + strDefaultParams;

        hypSetActiveSelection.NavigateUrl = "selectfeatures.aspx" + strDefaultParams;

        // For viewing source.
        String sourceFile;
        String sourcePath;

		// View queryfeatures source

		// aspx
        sourceFile = Server.UrlEncode(Server.MapPath("queryfeatures.aspx"));
        hypViewQueryFeatures.NavigateUrl = "../common/viewsource.aspx" + 
        "?FILENAME=" + sourceFile;

        // aspx.cs
        sourceFile = Server.UrlEncode(Server.MapPath("queryfeatures.aspx.cs"));
        hypViewQueryFeaturesCS.NavigateUrl = "../common/viewsource.aspx" + 
        "?FILENAME=" + sourceFile;


        // View selectfeatures source

		// aspx
        sourceFile = Server.UrlEncode(Server.MapPath("selectfeatures.aspx"));
        hypViewSelectFeatures.NavigateUrl = "../common/viewsource.aspx" + 
        "?FILENAME=" + sourceFile;

        // aspx.cs
        sourceFile = Server.UrlEncode(Server.MapPath("selectfeatures.aspx.cs"));
        hypViewSelectFeaturesCS.NavigateUrl = "../common/viewsource.aspx" + 
        "?FILENAME=" + sourceFile;


        // View listselection source

        // aspx
        sourceFile = Server.UrlEncode(Server.MapPath("listselection.aspx"));
        hypViewListSelection.NavigateUrl = "../common/viewsource.aspx" + 
        "?FILENAME=" + sourceFile;

        // aspx.cs
        sourceFile = Server.UrlEncode(Server.MapPath("listselection.aspx.cs"));
        hypViewListSelectionCS.NavigateUrl = "../common/viewsource.aspx" + 
        "?FILENAME=" + sourceFile;


        // View task_pane source

        // aspx
        sourceFile = Server.UrlEncode(Server.MapPath("task_pane.aspx"));
        hypViewTaskPane.NavigateUrl = "../common/viewsource.aspx" + 
        "?FILENAME=" + sourceFile;

        // aspx.cs
        sourceFile = Server.UrlEncode(Server.MapPath("task_pane.aspx.cs"));
        hypViewTaskPaneCS.NavigateUrl = "../common/viewsource.aspx" + 
        "?FILENAME=" + sourceFile;

    }
}
