﻿<!--
//  Copyright (C) 2004-2007 by Autodesk, Inc.
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of version 2.1 of the GNU Lesser
//  General Public License as published by the Free Software Foundation.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
-->

<%@ Page Language="C#" AutoEventWireup="true" CodeFile="task_pane.aspx.cs" 
Inherits="working_with_feature_data_task_pane" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" 
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head runat="server">
    <title>Working With Feature Data</title>
    <meta content="text/html; charset=utf-8" http-equiv="Content-Type" />
    <meta http-equiv="content-style-type" content="text/css" />
            <link href="../styles/dotnetsamples.css" rel="stylesheet" type="text/css"/>
    <meta http-equiv="content-script-type" content="text/javascript" />
    <script type="text/javascript">
    function ZoomToDistrict()
    {
        parent.parent.ZoomToView(-87.726134, 43.770338, 8000, true);
    }
    function listSelection()
    {
    xmlSel = parent.parent.mapFrame.GetSelectionXML();
    params = new Array(
        "SESSION", parent.parent.mapFrame.GetSessionId(), 
        "MAPNAME", parent.parent.mapFrame.GetMapName(),
        "SELECTION", xmlSel);
    pageUrl = "../dotnetsamples/working_with_feature_data/listselection.aspx";
    parent.parent.formFrame.Submit(pageUrl, params, "taskPaneFrame");
    }
    </script>
</head>
<body;>

    <form id="form1" runat="server">
    <div>

        <h1>Working With Feature Data</h1>

        <ul>

		<!-- task 'zoom to district' -->

		<li><a href="#" onclick="ZoomToDistrict();">Zoom to District 1</a></li>

        <li class="li-comment">
        Position the map to display parcels in District 1.</li>


		<!-- task 'query features' -->

        <li>
        <asp:HyperLink ID="hypQueryFeatures" runat="server">
        Query features</asp:HyperLink></li>

        <li class="li-comment">
        List properties in District 1 owned by people named Schmitt.</li>

		<!-- view queryfeatures source -->
        <li class="li-comment">
        View source: 
		<asp:HyperLink ID="hypViewQueryFeatures" runat="server" Target="_blank">
        aspx</asp:HyperLink> 
		<asp:HyperLink ID="hypViewQueryFeaturesCS" runat="server" Target="_blank">
		aspx.cs</asp:HyperLink>.</li>

		<!-- task 'select features' -->

        <li>
        <asp:HyperLink ID="hypSetActiveSelection" runat="server">
        Select features</asp:HyperLink></li>

        <li class="li-comment">
        Select properties in District 1 owned by people named Schmitt.</li>

		<!-- view selectfeatures source -->
        <li class="li-comment">
        View source: 
		<asp:HyperLink ID="hypViewSelectFeatures" runat="server" Target="_blank">
		aspx</asp:HyperLink> 
		<asp:HyperLink ID="hypViewSelectFeaturesCS" runat="server" Target="_blank">
		aspx.cs</asp:HyperLink>.</li>

		<!-- task 'list selected features' -->

        <li>
        <a href="#" onclick="listSelection();" >
        List selected features</a></li>
        <!-- debugging
        <asp:HyperLink ID="hypListSelectedFeatures" runat="server">
        List selected features</asp:HyperLink></li> -->

        <li class="li-comment">
        Lists currently selected features.</li>

        <!-- view listselection source -->
        <li class="li-comment">
        View source: 
        <asp:HyperLink ID="hypViewListSelection" runat="server" Target="_blank">
        aspx</asp:HyperLink> 
        <asp:HyperLink ID="hypViewListSelectionCS" runat="server" Target="_blank">
		aspx.cs</asp:HyperLink>.</li>

        </ul>

        <!-- view task_pane source -->
        <p>View the source for this task pane, showing JavaScript 
        for repositioning map and initiating selection list: 
		<asp:HyperLink ID="hypViewTaskPane" runat="server" Target="_blank">
        aspx</asp:HyperLink> 
		<asp:HyperLink ID="hypViewTaskPaneCS" runat="server" Target="_blank">
		aspx.cs</asp:HyperLink>.</p>

    </div>
    </form>

</body>
</html>
