//  Copyright (C) 2004-2007 by Autodesk, Inc.
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of version 2.1 of the GNU Lesser
//  General Public License as published by the Free Software Foundation.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using OSGeo.MapGuide;
using System.Collections.Specialized;

public partial class working_with_feature_data_listselection : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {

        String strDiagnostics = "<h2>Diagnostics</h2>";

        NameValueCollection requestParams = Request.HttpMethod == "GET" ? Request.QueryString : Request.Form;

        strDiagnostics += "<p>Request method: " + Request.HttpMethod  + "</p>";

        String strRequestParams = "";
        foreach (String str in requestParams.AllKeys)
        {

            strRequestParams += "<br/>" + str;

        }
        strDiagnostics += "<p>Request params: " + strRequestParams + "</p>";

        String mgSessionId = requestParams["SESSION"];
        String mgMapName = requestParams["MAPNAME"];
        String selectionXml = requestParams["SELECTION"];

        strDiagnostics += "<p>selectionXml: " + Server.HtmlEncode(selectionXml) + "</p>";

        // Initialize the web-tier.
        String realPath = Request.ServerVariables["APPL_PHYSICAL_PATH"];
        String configPath = realPath + "..\\webconfig.ini";
        MapGuideApi.MgInitializeWebTier(configPath);

        // Connect to the site.
        MgUserInformation userInfo = new MgUserInformation(mgSessionId);
        MgSiteConnection siteConnection = new MgSiteConnection();
        siteConnection.Open(userInfo);

        MgResourceService resourceService = siteConnection.CreateService(MgServiceType.ResourceService) as MgResourceService;
        MgFeatureService featureService = siteConnection.CreateService(MgServiceType.FeatureService) as MgFeatureService;

        MgMap map = new MgMap();
        map.Open(resourceService, mgMapName);

        MgReadOnlyLayerCollection layers;
        MgSelection selection = null;

        // ----------------------------------------------------------
        // Use the following code for AJAX or DWF Viewers
        // This requires passing selection data via HTTP POST
        if ((selectionXml != null) && (selectionXml != ""))
        {

            selection = new MgSelection(map, selectionXml);
            layers = selection.GetLayers();

            strDiagnostics += "<p>Got layers.</p>";

        }
        else
        {

            layers = null;

            strDiagnostics += "<p>Cannot get layers.</p>";

        }
        // ---------------------------------------------------------

        // ---------------------------------------------------------
        // Use the following code for AJAX Viewers only.
        // This does not require passing selection data via HTTP POST.
        //
        // MgSelection selection = new MgSelection(map);
        // selection.Open(resourceService, mapName);
        // layers = selection.GetLayers();
        // ---------------------------------------------------------

        if (layers != null)
        {
            MgFeatureQueryOptions queryOptions = new MgFeatureQueryOptions();
            for (int i = 0; i < layers.GetCount(); i++)
            {
                // Only check selected features in the Parcels layer.

                MgLayer layer = layers.GetItem(i) as MgLayer;

                if ((layer != null) && (layer.GetName() == @"Parcels"))
                {

                    // Create a filter containing the IDs of the selected features on this layer
                    String layerClassName = layer.GetFeatureClassName();
                    String selectionString = selection.GenerateFilter(layer, layerClassName);

                    // Get the feature resource for the selected layer

                    String layerFeatureId = layer.GetFeatureSourceId();
                    MgResourceIdentifier layerFeatureResource = new MgResourceIdentifier(layerFeatureId);

                    // Apply the filter to the feature resource for the selected layer. This returns
                    // an MgFeatureReader of all the selected features.

                    queryOptions.SetFilter(selectionString);
                    MgFeatureReader featureReader = featureService.SelectFeatures(layerFeatureResource, layerClassName, queryOptions);

                    // Process each item in the MgFeatureReader, displaying the owner name

                    String strParcelDataList = "";
 
                    while (featureReader.ReadNext())
                    {
                        strParcelDataList += featureReader.GetString(@"NAME") + "<br />" + featureReader.GetString(@"RPROPAD") + "<br /><br />";
                    }

                    litParcelDataList.Text = strParcelDataList;

                }
            }
        }
        else
        {

            litParcelDataList.Text = "No selected layers";

            // litDiagnostics.Text = strDiagnostics;

        }

    }
}
