<!--
//  Copyright (C) 2004-2007 by Autodesk, Inc.
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of version 2.1 of the GNU Lesser
//  General Public License as published by the Free Software Foundation.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
-->

<%@ Page language="c#" %>
<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Collections.Specialized" %>
<%@ Import Namespace="System.Text" %>
<%@ Import Namespace="System.Globalization" %>
<%@ Import Namespace="OSGeo.MapGuide" %>

<script runat="server">
String webLayout = "Library://Samples/Layouts/DotNetSamples.WebLayout";
String sessionId = "";
</script>

<%
    try
    {
        // Initialize a session and register a variable to hold the
        // session id, then initialize the Web Extensions, connect
        // to the site, and create a session.

        // Initialize Web Server Extensions.
        String realPath = Request.ServerVariables["APPL_PHYSICAL_PATH"];
        String configPath = realPath + "..\\webconfig.ini";
        MapGuideApi.MgInitializeWebTier(configPath);

        // Connect to the site.
        MgUserInformation userInfo = new MgUserInformation("Anonymous", "");
        MgSite site = new MgSite();
        site.Open(userInfo);

		// Create a session
        sessionId = site.CreateSession();

    }
    catch (Exception e)
    {
        Response.Write(e.Message);
    }
%>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Frameset//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" >
<head>
    <title>MapGuide Developer's Guide ASP.NET Samples</title>
</head>

<frameset rows="110,*" frameborder="no" framespacing="0">
	<frame id="titleFrame" frameborder="no" marginwidth="0" marginheight="0" scrolling="no" src="common/title.html">
	<frame id="viewerFrame" frameborder="no" marginwidth="0" marginheight="0" scrolling="no" src="../mapviewernet/ajaxviewer.aspx?SESSION=<%=sessionId%>&WEBLAYOUT=<%=webLayout%>">
</frameset>

</html>
