//  Copyright (C) 2004-2007 by Autodesk, Inc.
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of version 2.1 of the GNU Lesser
//  General Public License as published by the Free Software Foundation.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using OSGeo.MapGuide;
using System.Collections.Specialized;

public partial class interacting_with_layers_layer_visibility : System.Web.UI.Page
{

    protected void Page_Load(object sender, EventArgs e)
    {

		NameValueCollection requestParams = Request.HttpMethod == "GET" ? Request.QueryString : Request.Form;
		String mgSessionId = requestParams["SESSION"];
		String mgLocale = requestParams["LOCALE"];
		String mgMapName = requestParams["MAPNAME"];

		// Initialize the web-tier.
		String realPath = Request.ServerVariables["APPL_PHYSICAL_PATH"];
		String configPath = realPath + "..\\webconfig.ini";
		MapGuideApi.MgInitializeWebTier(configPath);

		// Connect to the site.
		MgUserInformation userInfo = new MgUserInformation(mgSessionId);
		MgSiteConnection siteConnection = new MgSiteConnection();
		siteConnection.Open(userInfo);

		// Get an instance of the required service(s).
        MgResourceService resourceService = siteConnection.CreateService(MgServiceType.ResourceService) as MgResourceService;

        // Get the current map.
        MgMap map = new MgMap();
        map.Open(resourceService, mgMapName);

        // Get map layers.
        MgLayerCollection mgLayers = map.GetLayers();

        // Define layer table "tblLayers".

        tblLayers.CssClass = "layers";
        tblLayers.Attributes.Add("cellspacing", "0");

        // Define table-head row.

        TableRow headRow = new TableRow();

        String[] columnTitles = new String[] { "Layer", "GetVisible( )", "IsVisible( )" };

        for (int i = 0; i < columnTitles.Length; i++)
        {

            TableCell td = new TableCell();
            td.CssClass = "head" + i;
            td.Text = columnTitles[i];
            headRow.Cells.Add(td);
            
        }

        tblLayers.Rows.Add(headRow);

        // Define table-body rows, one per layer.

        int mgLayerCount = mgLayers.Count;

        for (int i = 0; i < mgLayerCount; i++)
        {

            TableRow bodyRow = new TableRow();

            MgLayer mgLayer = mgLayers.GetItem(i) as MgLayer;

            String mgLayerName = mgLayer.Name;
            String mgLayerGetVisible = mgLayer.GetVisible() ? "on" : "off";
            String mgLayerIsVisible = mgLayer.IsVisible() ? "on" : "off";
            String[] mgLayerData = new String[] { mgLayerName, mgLayerGetVisible, mgLayerIsVisible };

            for (int j = 0; j < mgLayerData.Length; j++) 
            {

                TableCell td = new TableCell();
                td.CssClass = "body" + j;
                td.Text = mgLayerData[j];
                bodyRow.Cells.Add(td);

            }

            tblLayers.Rows.Add(bodyRow);

        }

    }

}
