﻿<!--
//  Copyright (C) 2004-2007 by Autodesk, Inc.
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of version 2.1 of the GNU Lesser
//  General Public License as published by the Free Software Foundation.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
-->

<%@ Page Language="C#" AutoEventWireup="true" CodeFile="gotopoint.aspx.cs" 
Inherits="hello_viewer_gotopoint" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" 
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head runat="server">
    <title>Go To Point</title>
    <meta content="text/html; charset=utf-8" http-equiv="Content-Type"/>
    <meta http-equiv="content-style-type" content="text/css"/>
            <link href="../styles/dotnetsamples.css" rel="stylesheet" type="text/css"/>
    <meta http-equiv="content-script-type" content="text/javascript"/>

    <!-- Emit this function and assocate it with the onLoad event for   -->
    <!-- the page so that it gets executed when this page loads in the  -->
    <!-- browser. The function calls the ZoomToView method on the       -->
    <!-- Viewer frame forcing the Viewer to navigate to the specified   -->
    <!-- point and scale.                                               -->

    <script type="text/javascript">
    
    function OnPageLoad()
    {
    
        var X = document.getElementById("hfX").getAttribute("value");
        var Y = document.getElementById("hfY").getAttribute("value");
        var Scale = document.getElementById("hfScale").getAttribute("value");
        
        // cast to integer
        X = parseFloat(X);
        Y = parseFloat(Y);
        Scale = parseFloat(Scale);
        
        // for debugging    
        var vars = X + ", " + Y + ", " + Scale;
        document.getElementById("showVars").firstChild.nodeValue = vars;
        document.getElementById("showVars").style.color = "red";

        parent.ZoomToView(X, Y, Scale, true);
        // parent.ZoomToView(-87.724520, 43.768387, 5000, true);
        
    }

    </script>
    
</head>
<body onload="OnPageLoad()">

    <form id="form1" runat="server">
    <div>

        <!-- For debugging -->    
        <asp:Label ID="labX" runat="server">X</asp:Label><br />
        <asp:Label ID="labY" runat="server">Y</asp:Label><br />
        <asp:Label ID="labScale" runat="server">Scale</asp:Label><br />
        
        <!-- For debugging -->    
        <p id="showVars">X, Y, Scale</p>
            
        <!-- Store request params for OnPageLoad() -->    
        <asp:HiddenField ID="hfX" runat="server" />
        <asp:HiddenField ID="hfY" runat="server" />
        <asp:HiddenField ID="hfScale" runat="server" />
        
    </div>
    </form>
    
</body>
</html>
