//  Copyright (C) 2004-2007 by Autodesk, Inc.
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of version 2.1 of the GNU Lesser
//  General Public License as published by the Free Software Foundation.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.IO;
using System.Collections.Specialized;
using System.Text.RegularExpressions;

public partial class common_viewsource : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {

        NameValueCollection requestParams = Request.HttpMethod == "GET" ? Request.QueryString : Request.Form;
        String sourceFile = requestParams["FILENAME"];

        // read the entire file
        StreamReader oStreamReader = File.OpenText(sourceFile);
        String strBucket = oStreamReader.ReadToEnd();
        oStreamReader.Close();

        // write file name without path to html page
        litFileName.Text = Path.GetFileName(sourceFile);

        // write full path name to html page

        // break the full-path string after 'www'
        String strOld = "www";
        String strNew = "www" + '\n' + "  ";
        sourceFile = sourceFile.Replace(strOld, strNew);
        litFullPath.Text = sourceFile;

        // replace each tab with four spaces
        strBucket = Regex.Replace(strBucket, @"\t", "    ");

        // replace '<' with '&lt;' etc
        strBucket = Server.HtmlEncode(strBucket);

        // wrap '&lt;...&gt;' substrings with span.htmltag
        strBucket = Regex.Replace(strBucket, @"(&lt;[^\s]+?&gt;)", "<span class=\"htmltag\">$1</span>");

        // wrap '&quot;...&quot;' substrings with span.attrval
        strBucket = Regex.Replace(strBucket, @"(&quot;[\w\W]*?&quot;)", "<span class=\"dblquot\">$1</span>");

        // replace '&amp;apos;' with apostrophe
        strBucket = Regex.Replace(strBucket, @"&amp;apos;", "\'");

        // replace '&amp;gt;' with '>'
        strBucket = Regex.Replace(strBucket, @"&amp;gt;", ">");

        // replace '&amp;lt;' with '<'
        strBucket = Regex.Replace(strBucket, @"&amp;lt;", "<");

        // wrap '&lt;!--...--&gt;' substrings with span.comment
        strBucket = Regex.Replace(strBucket, @"(&lt;!--[\w\W]*?--&gt;)", "<span class=\"comment\">$1</span>");

        // wrap '&lt;%--...--%&gt;' substrings with span.comment
        strBucket = Regex.Replace(strBucket, @"(&lt;%--[\w\W]*?--%&gt;)", "<span class=\"comment\">$1</span>");

        // wrap '/*...*/' substrings with span.comment
        strBucket = Regex.Replace(strBucket, @"(/\*[\w\W]*?\*/)", "<span class=\"comment\">$1</span>");

        // wrap '//...\n' substrings with span.comment
        strBucket = Regex.Replace(strBucket, @"(\s)(//.*)", "$1<span class=\"comment\">$2</span>");
        strBucket = Regex.Replace(strBucket, @"^(//.*)", "<span class=\"comment\">$1</span>");

        // Write file contents to html page
        litBucket.Text = strBucket;

    }
}
