<%--
Copyright (C) 2004-2007  Autodesk, Inc.
This library is free software; you can redistribute it and/or
modify it under the terms of version 2.1 of the GNU Lesser
General Public License as published by the Free Software Foundation.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
--%>

<%@ Import Namespace="System.Collections" %>
<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="OSGeo.MapGuide" %>

<script language="c#" runat="server">

NameValueCollection GetParameters()
{
    return Request.HttpMethod == "GET" ? Request.QueryString : Request.Form;
}

void InitializeWebTier()
{
    // Initialize web tier with the site configuration file.  The config
    // file should be in the same folder as this script.
    //
    string realPath = Request.ServerVariables["APPL_PHYSICAL_PATH"];
    String configPath =  realPath + "../webconfig.ini";
    MapGuideApi.MgInitializeWebTier(configPath);
}

// Searches the map for a layer with the specified name.

MgLayerBase GetLayerByName(MgMap map, String layerName)
{
    MgLayerBase layer = null;
    for (int i = 0; i < map.GetLayers().GetCount(); i++)
    {
        MgLayerBase nextLayer = map.GetLayers().GetItem(i);
        if (nextLayer.GetName() == layerName)
        {
            layer = nextLayer;
            break;
        }
    }
    return layer;
}

// Read the content from an MgByteReader and send it back as the response.
void OutputReaderContent(MgByteReader byteReader, HttpResponse response)
{
    MemoryStream memBuf = new MemoryStream();

    byte[] byteBuffer = new byte[1024];
    int numBytes = byteReader.Read(byteBuffer, 1024);
    while(numBytes > 0)
    {
        memBuf.Write(byteBuffer, 0, numBytes);
        numBytes = byteReader.Read(byteBuffer, 1024);
    }

    response.ContentType = byteReader.GetMimeType();
    byte [] content = memBuf.ToArray();
    response.OutputStream.Write(content , 0, content.Length);
}

</script>
