<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:output omit-xml-declaration="yes" method="text" indent="no"/>

    <!--The language of the document that needs to be transformed ('English', 'German' etc.)-->
    <xsl:param name="language"/>

	<xsl:template match="locale-mappings">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="locale-mapping">
		<xsl:if test="@language = $language">
			<xsl:text>lang.locale=</xsl:text>
 			<xsl:value-of select="@locale"/>
			<xsl:text>&#x0A;</xsl:text>

			<xsl:text>lang.chm-encoding=</xsl:text>
 			<xsl:value-of select="@chm-encoding"/>
			<xsl:text>&#x0A;</xsl:text>

			<xsl:text>lang.chm-language=</xsl:text>
 			<xsl:value-of select="@chm-language"/>
			<xsl:text>&#x0A;</xsl:text>
		</xsl:if>
	</xsl:template>

</xsl:stylesheet>