<?php

//
//  Copyright (C) 2004-2006  Autodesk, Inc.
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of version 2.1 of the GNU Lesser
//  General Public License as published by the Free Software Foundation.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//

?>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>

<head>
    <title>Viewer Sample Application - Find Parcels Task</title>
    <meta content="text/html; charset=utf-8" http-equiv="Content-Type">
    <meta http-equiv="content-script-type" content="text/javascript" />
    <meta http-equiv="content-style-type" content="text/css" />
    <link href="styles/globalstyles.css" rel="stylesheet" type="text/css">
    <link href="styles/alphastyles.css" rel="stylesheet" type="text/css">
        <link href="../viewerfiles/viewer.css" rel="stylesheet" type="text/css">
</head>

<body class="AppFrame">

<?php
    // Display a form prompting the user to enter the beginning
    // portion of the parcel owners name. Submitting this form
    // replaces the content of this frame with a list of matching
    // results.

    // If a Search has already been run and the results are still
    // visible (e.g. if the ParcelMarker layer is visible), then
    // display an button allowing the user to clear the previous
    // search results as well.

    include 'appconstants.php';
    include 'utilityfunctions.php';

    $mgSessionId = ($_SERVER['REQUEST_METHOD'] == "POST")? $_POST['SESSION']: $_GET['SESSION'];
    $showClearButton = false;

    try
    {
        // Initialize the Web Extensions and connect to the Server using
        // the Web Extensions session identifier stored in PHP session state.

        MgInitializeWebTier($configFilePath);

        $userInfo = new MgUserInformation($mgSessionId);
        $siteConnection = new MgSiteConnection();
        $siteConnection->Open($userInfo);

        // Create a ReserviceService object and use it to open the Map
        // object from the sessions repository. Use the Map object to
        // determine if the "ParcelMarker" layer is visible.

        $resourceService = $siteConnection->CreateService(MgServiceType::ResourceService);
        $map = new MgMap();
        $map->Open($resourceService, 'Sheboygan');

        $layer = GetLayerByName($map, 'ParcelMarker');
        $showClearButton = ($layer == null) ? false : $layer->GetVisible();
    }
    catch (MgException $e)
    {
        echo $e->GetMessage();
        echo $e->GetDetails();
    }
?>

<h1 class="AppHeading">Search Parcels by Owner</h1>

<form action="findparcels.php" method="get" target="_self">
    <label>Parcel Owner Begins With</label><br>
    <input name="Owner" type="text" size="30">
    <input name="SESSION" type="hidden" value="<?= $mgSessionId ?>">
    <br><br>
    <input type="submit" value="Find">
</form>

<hr>
<p>Hint try: Schmitt</p>
<hr>

<?php
    // Emit a second form with the Clear Results button if previous
    // search results are still displayed.

    if ($showClearButton)
    {
        echo '<form action="clearfindresults.php" method="get" target="scriptFrame">';
        echo '<input type="hidden" name="SESSION" value="' . $mgSessionId . '">';
        echo '<input type="submit" value="Clear Previous Results">';
        echo '</form>';
    }
?>

</body>

</html>
