<?php

//
//  Copyright (C) 2004-2006  Autodesk, Inc.
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of version 2.1 of the GNU Lesser
//  General Public License as published by the Free Software Foundation.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//

?>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>

<head>
    <title>Viewer Sample Application - Find Parcels</title>
    <meta content="text/html; charset=utf-8" http-equiv="Content-Type">
    <meta http-equiv="content-script-type" content="text/javascript" />
    <meta http-equiv="content-style-type" content="text/css" />
    <link href="styles/globalstyles.css" rel="stylesheet" type="text/css">
    <link href="styles/alphastyles.css" rel="stylesheet" type="text/css">
        <link href="../viewerfiles/viewer.css" rel="stylesheet" type="text/css">

    <script language=javascript>

        function InitDocument()
        {
            this.ZoomToResult();
        }
    </script>
</head>

<body class="AppFrame" onLoad="InitDocument()">

<h1 class="AppHeading">Find Results</h1>

<?php
    include 'appconstants.php';
    include 'utilityfunctions.php';
    include 'findparcelfunctions.php';

    $mgSessionId = ($_SERVER['REQUEST_METHOD'] == "POST")? $_POST['SESSION']: $_GET['SESSION'];
    $matches = 0;   // Variable to control output results.
    $mapUpdated = false;

    try
    {
        // Initialize the Web Extensions and connect to the Server using
        // the Web Extensions session identifier stored in PHP session state.

        MgInitializeWebTier ($configFilePath);

        $userInfo = new MgUserInformation($mgSessionId);
        $siteConnection = new MgSiteConnection();
        $siteConnection->Open($userInfo);

        // Initialize variables to be used in this script and create
        // instances of a FeatureService and ResourceService objects.

        $parcelMarkerFeatureSourceId = new MgResourceIdentifier("Session:" . $mgSessionId  . "//ParcelMarker.FeatureSource");
        $parcelMarkerCommands = new MgFeatureCommandCollection();

        $resourceService = $siteConnection->CreateService(MgServiceType::ResourceService);
        $featureService = $siteConnection->CreateService(MgServiceType::FeatureService);

        // Determine if a previous Search has been run. If not create a
        // temporary ParcelMarker feature source and layer. Otherwise
        // just delete the previous search results.

        $map = new MgMap();
        $map->Open($resourceService, 'Sheboygan');

        $parcelMarkerLayer = GetLayerByName($map, 'ParcelMarker');
        if ($parcelMarkerLayer == null)
        {
            CreateParcelMarkerFeatureSource($featureService, $parcelMarkerFeatureSourceId);
            $parcelMarkerLayer = CreateParcelMarkerLayer($resourceService, $parcelMarkerFeatureSourceId, $mgSessionId);

            $map->GetLayers()->Insert(0, $parcelMarkerLayer);
        }
        else
        {
            $parcelMarkerCommands->Add(new MgDeleteFeatures('ParcelMarker', "ID like '%'"));
        }

        // If an owner was specified create a FeatureService object and
        // use it to query all of the parcels with an owner that matches
        // the specified string. Get the name and centroid geometry
        // properties of each parcel feature and use that to build a
        // temporary dataset to display the pushpins and to construct
        // a table of hyperlinks, where each hyperlink forces the map
        // to navigate to that matching parcel.

        $owner = trim($_GET['Owner']);
        if (strlen($owner) > 0)
        {
            $filter = "RNAME LIKE '" . $owner . "%'";

            $featureResId = new MgResourceIdentifier("Library://Samples/Sheboygan/Data/Parcels.FeatureSource");
            $queryOptions = new MgFeatureQueryOptions();
            $queryOptions->SetFilter($filter);

            $geometryReaderWriter = new MgAgfReaderWriter();

            echo '<table width="100%"  border="0">';

            $featureReader = $featureService->SelectFeatures($featureResId, "Parcels", $queryOptions);

            while ($featureReader->ReadNext())
            {
                $name = $featureReader->GetString('RNAME');
                $byteReader = $featureReader->GetGeometry('SHPGEOM');

                $geometry = $geometryReaderWriter->Read($byteReader);
                $point = $geometry->GetCentroid();
                $x = $point->GetCoordinate()->GetX();
                $y = $point->GetCoordinate()->GetY();

                // Create an insert command for this parcel.

                $properties = new MgPropertyCollection();
                $properties->Add(new MgStringProperty('Owner', $name));
                $properties->Add(new MgGeometryProperty('Location', $geometryReaderWriter->Write($point)));
                $parcelMarkerCommands->Add(new MgInsertFeatures('ParcelMarker', $properties));

                // Add a row to the hyperlink table for this parcel.

                echo '<tr><td class="NavItem">';
                echo '<img class="NavPic" src="images/pushpin.jpg">';
                echo "<a class=\"NavLink\" href=\"gotopoint.php?X=$x&Y=$y&Scale=2000\" target=\"scriptFrame\">  $name</a></td></tr>";

                $matches++;
            }

            $featureReader->Close();

            echo '</table>';

            // If the parcel command set is non empty, then call the
            // UpdateFeatures method to apply the commands to the
            // temporary feature source. Then ensure the Parcel Marker
            // Layer is visible and force a refresh.

            if ($parcelMarkerCommands->GetCount() > 0)
            {
                $featureService->UpdateFeatures($parcelMarkerFeatureSourceId, $parcelMarkerCommands, false);

                $parcelMarkerLayer->SetVisible($matches > 0);
                $parcelMarkerLayer->ForceRefresh();

                $map->Save($resourceService);
                $mapUpdated = true;
            }
            else
            {
                echo '<tr><td class="NavItem">0 matches found.</td></tr>';
            }
        }
        else
        {
            echo '<tr><td class="NavItem">You must specify an owner!</td></tr>';
        }
    }
    catch (MgException $e)
    {
        echo $filter;
        echo $e->GetMessage();
        echo $e->GetDetails();
    }
?>

<br>

<?php
    // Emit a button to clear the find results or try again depending on
    // whether any matches were found.

    if ($matches > 0)
    {
            echo  $matches;
                echo  ' parcels found!';
            echo '<form action="clearfindresults.php" method="get" target="scriptFrame">';
        echo '<input type="hidden" name="SESSION" value="' . $mgSessionId . '">';
        echo '<input name="" type="submit" value="Clear Find Results">';
        echo '</form>';
    }
    else
    {
        echo '<form action="findparceltask.php" method="get" target="_self">';
        echo '<input type="hidden" name="SESSION" value="' . $mgSessionId . '">';
        echo '<input name="" type="submit" value="Try Again">';
        echo '</form>';
    }
?>

</body>

<!-- Emit this function that is assocated with the onLoad event for   -->
<!-- the page. The function calls the Refresh method on the Viewer    -->
<!-- frame forcing the Viewer to update itself to match the state of  -->
<!-- the Server-Side Map object.                                      -->

<script language=javascript>

function ZoomToResult()
{
<?php
    if ($mapUpdated)
    {
        echo 'parent.parent.Refresh();';
    }
?>
}

</script>

</html>
