<?php

//
//  Copyright (C) 2004-2006  Autodesk, Inc.
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of version 2.1 of the GNU Lesser
//  General Public License as published by the Free Software Foundation.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//

// Create a temporary Feature Source to store the parcel marker locations.

function CreateParcelMarkerFeatureSource($featureService, $parcelMarkerDataResId)
{
    $ll84Wkt = 'GEOGCS["LL84",DATUM["WGS_1984",SPHEROID["WGS 84",6378137,298.25722293287],TOWGS84[0,0,0,0,0,0,0]],PRIMEM["Greenwich",0],UNIT["Degrees",1]]';

    $parcelMarkerClass = new MgClassDefinition();
    $parcelMarkerClass->SetName('ParcelMarker');
    $properties = $parcelMarkerClass->GetProperties();

    $idProperty = new MgDataPropertyDefinition('ID');
    $idProperty->SetDataType(MgPropertyType::Int32);
    $idProperty->SetReadOnly(true);
    $idProperty->SetNullable(false);
    $idProperty->SetAutoGeneration(true);
    $properties->Add($idProperty);

    $ownerProperty = new MgDataPropertyDefinition('Owner');
    $ownerProperty->SetDataType(MgPropertyType::String);
    $ownerProperty->SetLength(512);
    $properties->Add($ownerProperty);

    $locationProperty = new MgGeometricPropertyDefinition('Location');
    $locationProperty->SetGeometryTypes(MgGeometryType::Point);
    $locationProperty->SetHasElevation(false);
    $locationProperty->SetHasMeasure(false);
    $locationProperty->SetReadOnly(false);
    $locationProperty->SetSpatialContextAssociation('LL84');
    $properties->Add($locationProperty);

    $idProperties = $parcelMarkerClass->GetIdentityProperties();
    $idProperties->Add($idProperty);

    $parcelMarkerClass->SetDefaultGeometryPropertyName('Location');

    $parcelMarkerSchema = new MgFeatureSchema();
    $parcelMarkerSchema->SetName('ParcelMarkerSchema');
    $parcelMarkerSchema->GetClasses()->Add($parcelMarkerClass);

    $sdfParams = new MgCreateSdfParams('LL84', $ll84Wkt, $parcelMarkerSchema);

    $featureService->CreateFeatureSource($parcelMarkerDataResId, $sdfParams);
}

// Create a temporary Layer to display the parcel markers.

function CreateParcelMarkerLayer($resourceService, $parcelMarkerDataResId, $sessionId)
{
    // Load the ParcelMarker layer definition template into
    // a PHP DOM object, find the "ResourceId" element, and
    // modify it's content to reference the temporary
    // feature source.

    $doc = DOMDocument::load('parcelmarker.xml');
    $featureSourceNode = $doc->getElementsByTagName('ResourceId')->item(0);
    $featureSourceNode->nodeValue = $parcelMarkerDataResId->ToString();

    // Get the updated layer definition from the DOM object
    // and save it to the session repository using the
    // ResourceService object.

    $layerDefinition = $doc->saveXML();
    $byteSource = new MgByteSource($layerDefinition, strlen($layerDefinition));
    $byteSource->SetMimeType(MgMimeType::Xml);

    $tempLayerResId = new MgResourceIdentifier("Session:" . $sessionId . "//ParcelMarker.LayerDefinition");

    $resourceService->SetResource($tempLayerResId, $byteSource->GetReader(), null);

    // Create an MgLayer object based on the new layer definition
    // and return it to the caller.

    $parcelMarkerLayer = new MgLayer($tempLayerResId, $resourceService);
    $parcelMarkerLayer->SetName("ParcelMarker");
    $parcelMarkerLayer->SetLegendLabel("ParcelMarker");
    $parcelMarkerLayer->SetDisplayInLegend(false);
    $parcelMarkerLayer->SetSelectable(false);

    return $parcelMarkerLayer;
}

?>
