<?php

//
//  Copyright (C) 2004-2006  Autodesk, Inc.
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of version 2.1 of the GNU Lesser
//  General Public License as published by the Free Software Foundation.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//

?>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>

<head>
    <title>Viewer Sample Application - Find Address Task</title>
    <meta content="text/html; charset=utf-8" http-equiv="Content-Type">
    <meta http-equiv="content-script-type" content="text/javascript" />
    <meta http-equiv="content-style-type" content="text/css" />
    <link href="styles/globalstyles.css" rel="stylesheet" type="text/css">
    <link href="styles/alphastyles.css" rel="stylesheet" type="text/css">
        <link href="../viewerfiles/viewer.css" rel="stylesheet" type="text/css">
</head>

<body class="AppFrame">

<?php
    include 'appconstants.php';
    include 'utilityfunctions.php';
    include 'findaddressfunctions.php';

    $mgSessionId = ($_SERVER['REQUEST_METHOD'] == "POST")? $_POST['SESSION']: $_GET['SESSION'];
    $showPreviousResults = false;

    try
    {
        // Initialize the Web Extensions and connect to the Server using
        // the Web Extensions session identifier stored in PHP session state.

        MgInitializeWebTier($configFilePath);

        $userInfo = new MgUserInformation($mgSessionId);
        $siteConnection = new MgSiteConnection();
        $siteConnection->Open($userInfo);

        // Create a ReserviceService object and use it to open the Map
        // object from the sessions repository. Use the Map object to
        // determine if the "AddressMarker" layer is visible.

        $resourceService = $siteConnection->CreateService(MgServiceType::ResourceService);
        $map = new MgMap();
        $map->Open($resourceService, 'Sheboygan');
        $addressLayer = GetLayerByName($map, 'AddressMarker');

        if ($addressLayer != null)
        {
            $showPreviousResults = $addressLayer->GetVisible();
        }
    }
    catch (MgException $e)
    {
        echo $e->GetMessage();
        echo $e->GetDetails();
    }
?>

<h1 class="AppHeading">Search for an Address</h1>

<form action="findaddress.php" method="get" target="_self">
    <input name="SESSION" type="hidden" value="<?= $mgSessionId ?>">
    <label>Address</label><br>
    <input name="address" type="text" size="30">
    <label><strong>Sheboygan, WI</strong></label>
    <br><br>
    <input type="submit" value="Find">
</form>

<hr>
<p>Hint try:
<br>&nbsp;&nbsp;601 North 5th Street
<br>&nbsp;&nbsp;720 Riverfront Drive
</p>
<hr>

<?php
    // If there are previous results, display them as hyperlinks and emit
    // a second form with a Clear Results button.

    if ($showPreviousResults)
    {
        $featureService = $siteConnection->CreateService(MgServiceType::FeatureService);
        $addressMarkerDataResId = new MgResourceIdentifier("Session:" . $mgSessionId . "//AddressMarker.FeatureSource");

        EmitAddressResults($featureService, $addressMarkerDataResId, $mgSessionId);
    }
?>

Geocoding Provided by: <a href="http://geocoder.us/" target="_blank">geocoder.us</a>.<br>
Locative Tecnologies offers the free geocoder.us web service for non commercial purposes. If you wish to use this geocoding web service in an production application you must sign up for a commercial license. Click the link above for more information.

</body>

</html>
