<%--
  -Copyright (C) 2004-2006  Autodesk, Inc.
  -This library is free software; you can redistribute it and/or
  -modify it under the terms of version 2.1 of the GNU Lesser
  -General Public License as published by the Free Software Foundation.

  -This library is distributed in the hope that it will be useful,
  -but WITHOUT ANY WARRANTY; without even the implied warranty of
  -MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  -Lesser General Public License for more details.

  -You should have received a copy of the GNU Lesser General Public
  -License along with this library; if not, write to the Free Software
  -Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
--%>

<%@ page import="org.osgeo.mapguide.*" %>
<%@ page import="java.util.*" %>
<%@ page import="java.io.*" %>
<%@ page import="java.text.*" %>
<%@ page import="javax.servlet.jsp.*" %>
<%@ page import="javax.servlet.http.*" %>
<%@ include file ="utilityfunctions.jsp" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>

<head>
    <title>Plot Task</title>
    <meta content="text/html; charset=utf-8" http-equiv="Content-Type">
    <meta http-equiv="content-script-type" content="text/javascript" />
    <meta http-equiv="content-style-type" content="text/css" />
    <link href="styles/globalstyles.css" rel="stylesheet" type="text/css">
    <link href="styles/alphastyles.css" rel="stylesheet" type="text/css">
    <link href="/viewerfiles/viewer.css" rel="stylesheet" type="text/css">
</head>

<body class="AppFrame">

<%
    // Display a couple of forms prompting the user to either
    // plot the current view of the map, or the current view of
    // the map at a specified scale. Submitting one of these forms
    // opens a new window containing an EPlot DWF. The EPlot DWF
    // is generated by the plot.jsp script.

    String mgSessionId = request.getParameter("SESSION");
    double currentScale = 0;
    NumberFormat nf = NumberFormat.getInstance();
    nf.setMaximumFractionDigits(3);
    MgPoint viewCenter = null;
    double viewScale = 0;

    try
    {
        // Initialize the web-tier and connect to the Site using
        // the session identifier stored in JSP session state.

        InitializeWebTier();

        MgUserInformation userInfo = new MgUserInformation(mgSessionId);
        MgSiteConnection siteConnection = new MgSiteConnection();
        siteConnection.Open(userInfo);

        // Create a ResourcService object and use it to open the Map
        // object from the sessions repository. Use the Map object to
        // determine the current scale of the map for display on this
        // page.

        MgResourceService resourceService = (MgResourceService)siteConnection.CreateService(MgServiceType.ResourceService);
        MgMap map = new MgMap();
        map.Open(resourceService, "Sheboygan");

        viewCenter = map.GetViewCenter();
        viewScale = map.GetViewScale();
    }
    catch (MgException e)
    {
        out.write(e.GetMessage());
        out.write(e.GetDetails());
        return;
    }
%>

<h1 class="AppHeading">Plot a View of the Map</h1>
<hr>

View Center X:  <%= nf.format(viewCenter.GetCoordinate().GetX()) %><br>
View Center Y:  <%= nf.format(viewCenter.GetCoordinate().GetY()) %><br><br>
View Scale:     1:<%= nf.format((int)viewScale) %><br><br>
<hr>

Plot the Current Map View
<form action="plot.jsp" method="get" target="_blank">
    <input name="SESSION" type="hidden" value="<%= mgSessionId %>">
    <input name="Scale" type="hidden" value="0">
    <input type="submit" value="Plot"><br><br>
    <input name="UseLayout" type="checkbox" value="true">
    <label>Use Print Layout</label>&nbsp;&nbsp;
</form>
<hr>

Plot the Current Map View at a Specified Scale
<form action="plot.jsp" method="get" target="_blank">
    <input name="SESSION" type="hidden" value="<%= mgSessionId %>">
    <label>Scale</label>&nbsp;&nbsp;
    <select name="Scale" size="1">
        <option value="1000">1:1,000</option>
        <option value="8000">1:8,000</option>
        <option value="20000">1:20,000</option>
        <option value="25000">1:25,000</option>
    </select>&nbsp;&nbsp;
    <input type="submit" value="Plot"><br><br>
    <input name="UseLayout" type="checkbox" value="true">
    <label>Use Print Layout</label>&nbsp;&nbsp;
</form>

</body>

</html>
