<%--
  -Copyright (C) 2004-2006  Autodesk, Inc.
  -This library is free software; you can redistribute it and/or
  -modify it under the terms of version 2.1 of the GNU Lesser
  -General Public License as published by the Free Software Foundation.

  -This library is distributed in the hope that it will be useful,
  -but WITHOUT ANY WARRANTY; without even the implied warranty of
  -MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  -Lesser General Public License for more details.

  -You should have received a copy of the GNU Lesser General Public
  -License along with this library; if not, write to the Free Software
  -Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
--%>

<%@ page import="org.osgeo.mapguide.*" %>
<%@ page import="java.util.*" %>
<%@ page import="java.io.*" %>
<%@ page import="javax.xml.parsers.*" %>
<%@ page import="javax.xml.transform.*" %>
<%@ page import="javax.xml.transform.dom.*" %>
<%@ page import="javax.xml.transform.stream.*" %>
<%@ page import="org.w3c.dom.*" %>

<%!
// Create a temporary Feature Source to store the parcel marker locations.

void CreateParcelMarkerFeatureSource(MgFeatureService featureService, MgResourceIdentifier parcelMarkerDataResId) throws MgException
{
    String ll84Wkt = "GEOGCS[\"LL84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.25722293287],TOWGS84[0,0,0,0,0,0,0]],PRIMEM[\"Greenwich\",0],UNIT[\"Degrees\",1]]";

    MgClassDefinition parcelMarkerClass = new MgClassDefinition();
    parcelMarkerClass.SetName("ParcelMarker");
    MgPropertyDefinitionCollection properties = parcelMarkerClass.GetProperties();

    MgDataPropertyDefinition idProperty = new MgDataPropertyDefinition("ID");
    idProperty.SetDataType(MgPropertyType.Int32);
    idProperty.SetReadOnly(true);
    idProperty.SetNullable(false);
    idProperty.SetAutoGeneration(true);
    properties.Add(idProperty);

    MgDataPropertyDefinition ownerProperty = new MgDataPropertyDefinition("Owner");
    ownerProperty.SetDataType(MgPropertyType.String);
    ownerProperty.SetLength(512);
    properties.Add(ownerProperty);

    MgGeometricPropertyDefinition locationProperty = new MgGeometricPropertyDefinition("Location");
    locationProperty.SetGeometryTypes(MgGeometryType.Point);
    locationProperty.SetHasElevation(false);
    locationProperty.SetHasMeasure(false);
    locationProperty.SetReadOnly(false);
    locationProperty.SetSpatialContextAssociation("LL84");
    properties.Add(locationProperty);

    MgPropertyDefinitionCollection idProperties = parcelMarkerClass.GetIdentityProperties();
    idProperties.Add(idProperty);

    parcelMarkerClass.SetDefaultGeometryPropertyName("Location");

    MgFeatureSchema parcelMarkerSchema = new MgFeatureSchema();
    parcelMarkerSchema.SetName("ParcelMarkerSchema");
    parcelMarkerSchema.GetClasses().Add(parcelMarkerClass);

    MgCreateSdfParams sdfParams = new MgCreateSdfParams("LL84", ll84Wkt, parcelMarkerSchema);

    featureService.CreateFeatureSource(parcelMarkerDataResId, sdfParams);
}

// Create a temporary Layer to display the parcel markers.

MgLayer CreateParcelMarkerLayer(MgResourceService resourceService, MgResourceIdentifier parcelMarkerDataResId, String sessionId) throws MgException, Exception
{
    // Load the ParcelMarker layer definition template into
    // a JSP DOM object, find the "ResourceId" element, and
    // modify it's content to reference the temporary
    // feature source.

    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    DocumentBuilder builder = factory.newDocumentBuilder();
    Document document = builder.parse(new File(getServletContext().getRealPath("/") + "javaviewersample" + File.separator + "parcelmarker.xml"));
    NodeList nodes = document.getElementsByTagName("ResourceId");
    Node resNode = nodes.item(0);
    Node resContent = document.createTextNode(parcelMarkerDataResId.ToString());
    resNode.appendChild(resContent);

    // write the modified layer XML definition into a byte stream
    //
    TransformerFactory tFactory = TransformerFactory.newInstance();
    Transformer transformer = tFactory.newTransformer();
    ByteArrayOutputStream bos = new ByteArrayOutputStream();
    DOMSource source = new DOMSource(document);
    StreamResult result = new StreamResult(bos);
    transformer.transform(source, result);

    // Save the updated layer definition to the session repository using the
    // ResourceService object.

    byte[] layerDefinition = bos.toByteArray();
    MgByteSource byteSource = new MgByteSource(layerDefinition, layerDefinition.length);
    byteSource.SetMimeType(MgMimeType.Xml);

    MgResourceIdentifier tempLayerResId = new MgResourceIdentifier("Session:" + sessionId + "//ParcelMarker.LayerDefinition");

    resourceService.SetResource(tempLayerResId, byteSource.GetReader(), null);

    // Create an MgLayer object based on the new layer definition
    // and return it to the caller.

    MgLayer parcelMarkerLayer = new MgLayer(tempLayerResId, resourceService);
    parcelMarkerLayer.SetName("ParcelMarker");
    parcelMarkerLayer.SetLegendLabel("ParcelMarker");
    parcelMarkerLayer.SetDisplayInLegend(false);
    parcelMarkerLayer.SetSelectable(false);

    return parcelMarkerLayer;
}
%>
