<%--
Copyright (C) 2004-2006  Autodesk, Inc.
This library is free software; you can redistribute it and/or
modify it under the terms of version 2.1 of the GNU Lesser
General Public License as published by the Free Software Foundation.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
--%>

<%@ Page language="c#" %>
<%@ Import Namespace="System" %>
<%@ Import Namespace="System.Globalization" %>
<%@ Import Namespace="OSGeo.MapGuide" %>
<!-- #Include File="utilityfunctions.aspx" -->

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>

<head>
    <title>MapGuide Server Sample - Plot Task</title>
    <meta content="text/html; charset=utf-8" http-equiv="Content-Type">
    <meta http-equiv="content-script-type" content="text/javascript" />
    <meta http-equiv="content-style-type" content="text/css" />
    <link href="styles/globalstyles.css" rel="stylesheet" type="text/css">
    <link href="styles/alphastyles.css" rel="stylesheet" type="text/css">
    <link href="/mapguide/viewerfiles/viewer.css" rel="stylesheet" type="text/css">
</head>

<body class="AppFrame">
<%
// Display a couple of forms prompting the user to either
// plot the current view of the map, or the current view of
// the map at a specified scale. Submitting one of these forms
// opens a new window containing an EPlot DWF. The EPlot DWF
// is generated by the plot.aspx script.

String mgSessionId = GetParameters()["SESSION"];
int currentScale = 0;
NumberFormatInfo nf = new NumberFormatInfo();
nf.NumberDecimalDigits = 3;
MgPoint viewCenter = null;
double viewScale = 0;

try
{
    // Initialize the web- extensions and connect to the Site using
    // the session identifier stored in PHP session state.

    InitializeWebTier();

    MgUserInformation userInfo = new MgUserInformation(mgSessionId);
    MgSiteConnection siteConnection = new MgSiteConnection();
    siteConnection.Open(userInfo);

    // Create a ReserviceService object and use it to open the Map
    // object from the sessions repository. Use the Map object to
    // determine the current scale of the map for display on this
    // page.

    MgResourceService resourceService = siteConnection.CreateService(MgServiceType.ResourceService) as MgResourceService;
    MgMap map = new MgMap();
    map.Open(resourceService, "Sheboygan");

    viewCenter = map.GetViewCenter();
    viewScale = map.GetViewScale();
}
catch (MgException mge)
{
    Response.Write(mge.GetMessage());
    Response.Write(mge.GetDetails());
}
%>
   <h1 class="AppHeading">Plot a View of the Map</h1>
<hr>

View Center X:  <%= viewCenter.GetCoordinate().GetX().ToString(nf) %><br>
View Center Y:  <%= viewCenter.GetCoordinate().GetY().ToString(nf) %><br><br>
View Scale:     1:<%= ((int)viewScale).ToString(nf) %><br><br>
<hr>

Plot the Current Map View
<form action="plot.aspx" method="post" target="_blank">
    <input name="SESSION" type="hidden" value="<%= mgSessionId %>">
    <input name="Scale" type="hidden" value="0">
    <input type="submit" value="Plot"><br><br>
    <input name="UseLayout" type="checkbox" value="true">
    <label>Use Print Layout</label>&nbsp;&nbsp;
</form>
<hr>

Plot the Current Map View at a Specified Scale
<form action="plot.aspx" method="post" target="_blank">
    <input name="SESSION" type="hidden" value="<%= mgSessionId %>">
    <label>Scale</label>&nbsp;&nbsp;
    <select name="Scale" size="1">
        <option value="1000">1:1,000</option>
        <option value="8000">1:8,000</option>
        <option value="20000">1:20,000</option>
        <option value="25000">1:25,000</option>
    </select>&nbsp;&nbsp;
    <input type="submit" value="Plot"><br><br>
    <input name="UseLayout" type="checkbox" value="true">
    <label>Use Print Layout</label>&nbsp;&nbsp;
</form>

</body>

</html>
