<%--
Copyright (C) 2004-2006  Autodesk, Inc.
This library is free software; you can redistribute it and/or
modify it under the terms of version 2.1 of the GNU Lesser
General Public License as published by the Free Software Foundation.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
--%>

<%@ Page language="c#" %>
<%@ Import Namespace="OSGeo.MapGuide" %>
<!-- #Include File="utilityfunctions.aspx" -->
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>

<head>
    <title>Viewer Sample Application -  Navigate Task</title>
    <meta content="text/html; charset=utf-8" http-equiv="Content-Type">
    <meta http-equiv="content-script-type" content="text/javascript" />
    <meta http-equiv="content-style-type" content="text/css" />
    <link href="styles/globalstyles.css" rel="stylesheet" type="text/css">
    <link href="styles/alphastyles.css" rel="stylesheet" type="text/css">
    <link href="../viewerfiles/viewer.css" rel="stylesheet" type="text/css">
</head>

<body class="AppFrame">

<h1 class="AppHeading">Navigate by Municipal District</h1>

<table width="100%"  border="0">
<%
String mgSessionId = GetParameters()["SESSION"];

try
{
    // Initialize the web-tier and connect to the Site using
    // the session identifier stored in Aspx session state.
    InitializeWebTier ();

    MgUserInformation userInfo = new MgUserInformation(mgSessionId);
    MgSiteConnection siteConnection = new MgSiteConnection();
    siteConnection.Open(userInfo);

    // Create a FeatureService object and use it to query all of the
    // districts from the "VotingDistricts" feature source. Get the
    // name and geometry properties of each district feature and use
    // that to construct the table of hyperlinks.

    MgFeatureService featureService = siteConnection.CreateService(MgServiceType.FeatureService) as MgFeatureService;

    MgResourceIdentifier resId = new MgResourceIdentifier("Library://Samples/Sheboygan/Data/VotingDistricts.FeatureSource");

    MgFeatureReader featureReader = featureService.SelectFeatures(resId, "VotingDistricts", null);

    MgPropertyCollection tableData = new MgPropertyCollection();
    MgAgfReaderWriter geometryReaderWriter = new MgAgfReaderWriter();

    while (featureReader.ReadNext())
    {
        int key = featureReader.GetInt32("Autogenerated_SDF_ID");
        MgByteReader byteReader = featureReader.GetGeometry("Data");

        MgGeometry geometry = geometryReaderWriter.Read(byteReader);
        MgPoint point = geometry.GetCentroid();
        double x = point.GetCoordinate().GetX();
        double y = point.GetCoordinate().GetY();

        tableData.Add(new MgStringProperty(key.ToString(), "gotopoint.aspx?X="+x+"&Y="+y+"&Scale=25000"));
    }
    featureReader.Close();

    // Output the hyperlinks in sorted order. The SDF+ FDO
    // Provider does not support the OrderingFilter in
    // FeatureQueryOptions yet...

    for (int i = 1; i <= tableData.GetCount(); i++)
    {
        MgStringProperty property = tableData.GetItem(i.ToString()) as MgStringProperty;
        Response.Write("<tr><td><hr><a href=" + "\"" + property.GetValue() + "\"" + "target=\"scriptFrame\"><b>District " + property.GetName() + "</b></a></td></tr>");
    }
}
catch (MgException mge)
{
    Response.Write(mge.GetMessage());
    Response.Write(mge.GetDetails());
}

%>
    <tr><td><hr></td></tr>
</table>

</body>

</html>
