<%--
Copyright (C) 2004-2006  Autodesk, Inc.
This library is free software; you can redistribute it and/or
modify it under the terms of version 2.1 of the GNU Lesser
General Public License as published by the Free Software Foundation.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
--%>

<%@ Page Language="C#" Debug="true" %>
<%@ Import Namespace="System" %>
<%@ Import Namespace="OSGeo.MapGuide" %>
<!-- #Include File="utilityfunctions.aspx" -->
<!-- #Include File="findparcelfunctions.aspx" -->
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
    <head>
        <title>Viewer Sample Application - Find Parcels</title>
        <meta content="text/html; charset=utf-8" http-equiv="Content-Type">
        <meta http-equiv="content-script-type" content="text/javascript" />
        <meta http-equiv="content-style-type" content="text/css" />
        <link href="styles/globalstyles.css" rel="stylesheet" type="text/css">
        <link href="styles/alphastyles.css" rel="stylesheet" type="text/css">
        <link href="/mapguide/viewerfiles/viewer.css" rel="stylesheet" type="text/css">

        <script language=javascript>

            function InitDocument()
            {
                this.ZoomToResult();
            }
        </script>
    </head>

    <body class="AppFrame" onLoad="InitDocument()">

    <h1 class="AppHeading">Find Results</h1>

    <%
        String mgSessionId = GetParameters()["SESSION"];
        int matches = 0; // Variable to control output results.
        bool mapUpdated = false;

        try
        {
            // Initialize the web-tier and connect to the Tux Site using
            // the Tux session retrieved from the query string.
            InitializeWebTier();

            MgUserInformation userInfo = new MgUserInformation(mgSessionId);
            MgSiteConnection siteConnection = new MgSiteConnection();
            siteConnection.Open(userInfo);

            // Initialize variables to be used in this script and create
            // instances of a FeatureService and ResourceService objects.

            MgResourceIdentifier parcelMarkerFeatureSourceId = new MgResourceIdentifier("Session:" + mgSessionId  + "//ParcelMarker.FeatureSource");
            MgFeatureCommandCollection parcelMarkerCommands = new MgFeatureCommandCollection();

            MgResourceService resourceService = siteConnection.CreateService(MgServiceType.ResourceService) as MgResourceService;
            MgFeatureService featureService = siteConnection.CreateService(MgServiceType.FeatureService) as MgFeatureService;

            // Determine if a previous Search has been run. If not create a
            // temporary ParcelMarker feature source and layer. Otherwise
            // just delete the previous search results.

            MgMap map = new MgMap();
            map.Open(resourceService, "Sheboygan");

            MgLayer parcelMarkerLayer = GetLayerByName(map, "ParcelMarker");
            if (parcelMarkerLayer == null)
            {
                CreateParcelMarkerFeatureSource(featureService, parcelMarkerFeatureSourceId);
                parcelMarkerLayer = CreateParcelMarkerLayer(resourceService, parcelMarkerFeatureSourceId, mgSessionId);

                map.GetLayers().Insert(0, parcelMarkerLayer);
            }
            else
            {
                parcelMarkerCommands.Add(new MgDeleteFeatures("ParcelMarker", "ID like '%'"));
            }

            // If an owner was specified create a FeatureService object and
            // use it to query all of the parcels with an owner that matches
            // the specified string. Get the name and centroid geometry
            // properties of each parcel feature and use that to build a
            // temporary dataset to display the pushpins and to construct
            // a table of hyperlinks, where each hyperlink forces the map
            // to navigate to that matching parcel.

            String owner = GetParameters()["Owner"].Trim();
            if (owner.Length > 0)
            {
                String filter = "RNAME LIKE '" + owner + "%'";

                MgResourceIdentifier featureResId = new MgResourceIdentifier("Library://Samples/Sheboygan/Data/Parcels.FeatureSource");
                MgFeatureQueryOptions queryOptions = new MgFeatureQueryOptions();
                queryOptions.SetFilter(filter);

                MgAgfReaderWriter geometryReaderWriter = new MgAgfReaderWriter();

                Response.Write("<table width=\"100%\"  border=\"0\">");

                MgFeatureReader featureReader = featureService.SelectFeatures(featureResId, "Parcels", queryOptions);

                while (featureReader.ReadNext())
                {
                    String name = featureReader.GetString("RNAME");
                    MgByteReader byteReader = featureReader.GetGeometry("SHPGEOM");

                    MgGeometry geometry = geometryReaderWriter.Read(byteReader);
                    MgPoint point = geometry.GetCentroid();
                    double x = point.GetCoordinate().GetX();
                    double y = point.GetCoordinate().GetY();

                    // Create an insert command for this parcel.

                    MgPropertyCollection properties = new MgPropertyCollection();
                    properties.Add(new MgStringProperty("Owner", name));
                    properties.Add(new MgGeometryProperty("Location", geometryReaderWriter.Write(point)));
                    parcelMarkerCommands.Add(new MgInsertFeatures("ParcelMarker", properties));

                    // Add a row to the hyperlink table for this parcel.

                    Response.Write("<tr><td class=\"NavItem\">");
                    Response.Write("<img class=\"NavPic\" src=\"images/pushpin.jpg\">");
                    Response.Write("<a class=\"NavLink\" href=\"gotopoint.aspx?X="+x+"&Y="+y+"&Scale=2000\" target=\"scriptFrame\">"+ name + "</a></td></tr>");

                    matches++;
                }
                featureReader.Close();

                Response.Write("</table>");

                // If the parcel command set is non empty, then call the
                // UpdateFeatures method to apply the commands to the
                // temporary feature source. Then ensure the Parcel Marker
                // Layer is visible and force a refresh.

                if (parcelMarkerCommands.GetCount() > 0)
                {
                    ReleaseReader(featureService.UpdateFeatures(parcelMarkerFeatureSourceId, parcelMarkerCommands, false), parcelMarkerCommands);

                    parcelMarkerLayer.SetVisible(matches > 0);
                    parcelMarkerLayer.ForceRefresh();

                    map.Save(resourceService);
                    mapUpdated = true;
                }
                else
                {
                    Response.Write("<tr><td class=\"NavItem\">0 matches found.</td></tr>");
                }
            }
            else
            {
                Response.Write("<tr><td class=\"NavItem\">You must specify an owner!</td></tr>");
            }
        }
        catch (MgException mge)
        {
            Response.Write(mge.GetMessage());
            Response.Write(mge.GetDetails());
        }

    %>
    <br>

<%
    // Emit a button to clear the find results or try again depending on
    // whether any matches were found.

    if (matches > 0)
    {
        Response.Write("<form action=\"clearfindresults.aspx\" method=\"get\" target=\"scriptFrame\">");
        Response.Write("<input type=\"hidden\" name=\"SESSION\" value=\"" + mgSessionId + "\">");
        Response.Write("<input name=\"\" type=\"submit\" value=\"Clear Find Results\">");
        Response.Write("</form>");
    }
    else
    {
        Response.Write("<form action=\"findparceltask.aspx\" method=\"get\" target=\"_self\">");
        Response.Write("<input type=\"hidden\" name=\"SESSION\" value=\"" + mgSessionId + "\">");
        Response.Write("<input name=\"\" type=\"submit\" value=\"Try Again\">");
        Response.Write("</form>");
    }
%>

</body>

<!-- Emit this function that is assocated with the onLoad event for   -->
<!-- the page. The function calls the Refresh method on the Viewer    -->
<!-- frame forcing the Viewer to update itself to match the state of  -->
<!-- the Server-Side Map object.                                      -->

<script language=javascript>

function ZoomToResult()
{
<%
    if (mapUpdated)
    {
        Response.Write("parent.parent.Refresh();");
    }
%>
}

</script>

</html>
