<%--
Copyright (C) 2004-2006  Autodesk, Inc.
This library is free software; you can redistribute it and/or
modify it under the terms of version 2.1 of the GNU Lesser
General Public License as published by the Free Software Foundation.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
--%>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Text" %>
<%@ Import Namespace="System.Xml" %>
<script language="c#" runat="server">
void CreateParcelMarkerFeatureSource(MgFeatureService featureService, MgResourceIdentifier parcelMarkerDataResId)
{
    String ll84Wkt = "GEOGCS[\"LL84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.25722293287],TOWGS84[0,0,0,0,0,0,0]],PRIMEM[\"Greenwich\",0],UNIT[\"Degrees\",1]]";

    MgClassDefinition parcelMarkerClass = new MgClassDefinition();
    parcelMarkerClass.SetName("ParcelMarker");
    MgPropertyDefinitionCollection properties = parcelMarkerClass.GetProperties();

    MgDataPropertyDefinition idProperty = new MgDataPropertyDefinition("ID");
    idProperty.SetDataType(MgPropertyType.Int32);
    idProperty.SetReadOnly(true);
    idProperty.SetNullable(false);
    idProperty.SetAutoGeneration(true);
    properties.Add(idProperty);

    MgDataPropertyDefinition ownerProperty = new MgDataPropertyDefinition("Owner");
    ownerProperty.SetDataType(MgPropertyType.String);
    ownerProperty.SetLength(512);
    properties.Add(ownerProperty);

    MgGeometricPropertyDefinition locationProperty = new MgGeometricPropertyDefinition("Location");
    locationProperty.SetGeometryTypes(MgGeometryType.Point);
    locationProperty.SetHasElevation(false);
    locationProperty.SetHasMeasure(false);
    locationProperty.SetReadOnly(false);
    locationProperty.SetSpatialContextAssociation("LL84");
    properties.Add(locationProperty);

    MgPropertyDefinitionCollection idProperties = parcelMarkerClass.GetIdentityProperties();
    idProperties.Add(idProperty);

    parcelMarkerClass.SetDefaultGeometryPropertyName("Location");

    MgFeatureSchema parcelMarkerSchema = new MgFeatureSchema();
    parcelMarkerSchema.SetName("ParcelMarkerSchema");
    parcelMarkerSchema.GetClasses().Add(parcelMarkerClass);

    MgCreateSdfParams sdfParams = new MgCreateSdfParams("LL84", ll84Wkt, parcelMarkerSchema);

    featureService.CreateFeatureSource(parcelMarkerDataResId, sdfParams);
}

// Create a temporary Layer to display the parcel markers.

MgLayer CreateParcelMarkerLayer(MgResourceService resourceService, MgResourceIdentifier parcelMarkerDataResId, String sessionId)
{
    // Load the ParcelMarker layer definition template into
    // a C# XML object, find the "ResourceId" element, and
    // modify it's content to reference the temporary
    // feature source.
    try
    {
        XmlDocument doc = new XmlDocument();
        doc.PreserveWhitespace=false;
        doc.Load(Request.ServerVariables["APPL_PHYSICAL_PATH"] + "parcelmarker.xml");
        XmlNode featureSourceNode = doc.GetElementsByTagName("ResourceId").Item(0);
        XmlNode resContent = doc.CreateTextNode(parcelMarkerDataResId.ToString());
        featureSourceNode.AppendChild(resContent);

        // Get the updated layer definition from the DOM object
        // and save it to the session repository using the
        // ResourceService object.

        MemoryStream xmlStream = new MemoryStream();
        doc.Save(xmlStream);
        byte [] layerDefinition = xmlStream.ToArray();
        Encoding utf8 = Encoding.UTF8;
        String layerDefStr = new String(utf8.GetChars(layerDefinition));
        layerDefinition = new byte[layerDefStr.Length-1];
        int byteCount = utf8.GetBytes(layerDefStr, 1, layerDefStr.Length-1, layerDefinition, 0);
        MgByteSource byteSource = new MgByteSource(layerDefinition, layerDefinition.Length);
        byteSource.SetMimeType(MgMimeType.Xml);

        MgResourceIdentifier tempLayerResId = new MgResourceIdentifier("Session:" + sessionId + "//ParcelMarker.LayerDefinition");

        resourceService.SetResource(tempLayerResId, byteSource.GetReader(), null);

        // Create an MgLayer object based on the new layer definition
        // and return it to the caller.

        MgLayer parcelMarkerLayer = new MgLayer(tempLayerResId, resourceService);

        parcelMarkerLayer.SetName("ParcelMarker");
        parcelMarkerLayer.SetLegendLabel("ParcelMarker");
        parcelMarkerLayer.SetDisplayInLegend(false);
        parcelMarkerLayer.SetSelectable(false);
        return parcelMarkerLayer;
    }

    catch (MgException mge)
    {
        Response.Write(mge.GetMessage());
        Response.Write(mge.GetDetails());
        return null;
    }
    catch (Exception exc)
    {
        Response.Write(exc.Message);
        return null;
    }
}

void ReleaseReader(MgPropertyCollection res, MgFeatureCommandCollection commands)
{
    if(res == null)
        return;

    for(int i = 0; i < res.GetCount(); i++)
    {
        MgFeatureCommand cmd = commands.GetItem(i);
        if(cmd is MgInsertFeatures)
        {
            MgFeatureProperty resProp = res.GetItem(i) as MgFeatureProperty;
            if(resProp != null)
            {
                MgFeatureReader reader = resProp.GetValue() as MgFeatureReader;
                if(reader == null)
                    return;
                reader.Close();
            }
        }
    }
}
</script>
