/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.vector.iterator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geoserver.wms.vector.iterator.VTFeature;
import org.geoserver.wms.vector.iterator.VTIterator;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.locationtech.jts.geom.Geometry;

class SimpleVTIterator
implements VTIterator {
    SimpleFeatureIterator delegate;
    VTFeature curr;
    private List<AttributeDescriptor> descriptors;

    public SimpleVTIterator(SimpleFeatureIterator delegate) {
        this.delegate = delegate;
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public VTFeature next() {
        SimpleFeature f = (SimpleFeature)this.delegate.next();
        return new VTFeature(f.getID(), (Geometry)f.getDefaultGeometry(), this.getProperties(f));
    }

    private Map<String, Object> getProperties(SimpleFeature f) {
        if (this.descriptors == null) {
            this.descriptors = f.getFeatureType().getAttributeDescriptors();
        }
        List attributeValues = f.getAttributes();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (int i = 0; i < this.descriptors.size(); ++i) {
            AttributeDescriptor ad = this.descriptors.get(i);
            if (ad instanceof GeometryDescriptor) continue;
            properties.put(ad.getLocalName(), attributeValues.get(i));
        }
        return properties;
    }
}

