/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.vector.iterator;

import org.geoserver.wms.vector.iterator.VTFeature;
import org.geoserver.wms.vector.iterator.VTIterator;

public class PushBackVTIterator
implements VTIterator {
    VTFeature last;
    VTFeature current;
    VTIterator delegate;

    public PushBackVTIterator(VTIterator delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean hasNext() {
        return this.current != null || this.delegate.hasNext();
    }

    @Override
    public VTFeature next() {
        if (this.current != null) {
            this.last = this.current;
            this.current = null;
        } else {
            this.last = this.delegate.next();
        }
        return this.last;
    }

    public void pushBack() {
        if (this.last == null) {
            throw new IllegalStateException("There is no feature to push back");
        }
        this.current = this.last;
        this.last = null;
    }

    @Override
    public void close() {
        this.delegate.close();
    }
}

