/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.vector;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.MapProducerCapabilities;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WebMap;
import org.geoserver.wms.map.AbstractMapOutputFormat;
import org.geoserver.wms.map.StyleQueryUtil;
import org.geoserver.wms.vector.Pipeline;
import org.geoserver.wms.vector.PipelineBuilder;
import org.geoserver.wms.vector.VectorTileBuilder;
import org.geoserver.wms.vector.VectorTileBuilderFactory;
import org.geoserver.wms.vector.VectorTileOptions;
import org.geoserver.wms.vector.iterator.VTFeature;
import org.geoserver.wms.vector.iterator.VTIterator;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.Layer;
import org.geotools.process.geometry.PolygonLabelProcess;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public class VectorTileMapOutputFormat
extends AbstractMapOutputFormat {
    private static final Logger LOGGER = Logging.getLogger(VectorTileMapOutputFormat.class);
    private final VectorTileBuilderFactory tileBuilderFactory;
    private boolean clipToMapBounds;
    private double overSamplingFactor = 2.0;
    private boolean transformToScreenCoordinates;

    public VectorTileMapOutputFormat(VectorTileBuilderFactory tileBuilderFactory) {
        super(tileBuilderFactory.getMimeType(), tileBuilderFactory.getOutputFormats());
        this.tileBuilderFactory = tileBuilderFactory;
    }

    public void setOverSamplingFactor(double factor) {
        this.overSamplingFactor = factor;
    }

    public void setClipToMapBounds(boolean clip) {
        this.clipToMapBounds = clip;
    }

    public void setTransformToScreenCoordinates(boolean useScreenCoords) {
        this.transformToScreenCoordinates = useScreenCoords;
    }

    public WebMap produceMap(WMSMapContent mapContent) throws ServiceException, IOException {
        Preconditions.checkNotNull((Object)mapContent);
        Preconditions.checkNotNull((Object)mapContent.getRenderingArea());
        Preconditions.checkArgument((mapContent.getMapWidth() > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((mapContent.getMapHeight() > 0 ? 1 : 0) != 0);
        ReferencedEnvelope renderingArea = mapContent.getRenderingArea();
        int mapWidth = mapContent.getMapWidth();
        int mapHeight = mapContent.getMapHeight();
        Rectangle paintArea = new Rectangle(mapWidth, mapHeight);
        if (this.tileBuilderFactory.shouldOversampleScale()) {
            paintArea = new Rectangle(this.tileBuilderFactory.getOversampleX() * mapWidth, this.tileBuilderFactory.getOversampleY() * mapHeight);
        }
        VectorTileBuilder vectorTileBuilder = this.tileBuilderFactory.newBuilder(paintArea, renderingArea);
        for (Layer layer : mapContent.layers()) {
            FeatureSource featureSource = layer.getFeatureSource();
            FeatureType schema = featureSource.getSchema();
            GeometryDescriptor geometryDescriptor = schema.getGeometryDescriptor();
            if (null == geometryDescriptor) continue;
            CoordinateReferenceSystem sourceCrs = geometryDescriptor.getType().getCoordinateReferenceSystem();
            int buffer = StyleQueryUtil.getComputedBuffer((int)mapContent.getBuffer(), (List)StyleQueryUtil.getFeatureStyles((Layer)layer, (double)StyleQueryUtil.getMapScale((WMSMapContent)mapContent, (ReferencedEnvelope)renderingArea), (FeatureType)schema));
            if (this.tileBuilderFactory.shouldOversampleScale()) {
                buffer *= Math.max(Math.max(this.tileBuilderFactory.getOversampleX(), this.tileBuilderFactory.getOversampleY()), 1);
            }
            VectorTileOptions vectorTileOptions = new VectorTileOptions(layer, mapContent);
            Query query = StyleQueryUtil.getStyleQuery((Layer)layer, (WMSMapContent)mapContent);
            vectorTileOptions.customizeQuery(query);
            Hints hints = query.getHints();
            Pipeline pipeline = this.getPipeline(mapContent, renderingArea, paintArea, sourceCrs, featureSource.getSupportedHints(), hints, buffer);
            hints.remove((Object)Hints.SCREENMAP);
            FeatureCollection features = featureSource.getFeatures(query);
            Object layerName = schema.getName().getLocalPart();
            boolean coalesceEnabled = vectorTileOptions.isCoalesceEnabled();
            this.run(features, pipeline, geometryDescriptor, vectorTileBuilder, layer, false, (String)layerName, coalesceEnabled);
            if (!vectorTileOptions.generateLabelLayer()) continue;
            vectorTileOptions.customizeLabelQuery(query);
            features = featureSource.getFeatures(query);
            layerName = (String)layerName + "_labels";
            this.run(features, pipeline, geometryDescriptor, vectorTileBuilder, layer, vectorTileOptions.isPolygonLabelEnabled(), (String)layerName, coalesceEnabled);
        }
        return vectorTileBuilder.build(mapContent);
    }

    protected Pipeline getPipeline(WMSMapContent mapContent, ReferencedEnvelope renderingArea, Rectangle paintArea, CoordinateReferenceSystem sourceCrs, Set<RenderingHints.Key> fsHints, Hints qHints, int buffer) {
        Pipeline pipeline;
        try {
            PipelineBuilder builder = PipelineBuilder.newBuilder(renderingArea, paintArea, sourceCrs, this.overSamplingFactor, buffer);
            pipeline = builder.preprocess().transform(this.transformToScreenCoordinates).clip(this.clipToMapBounds, this.transformToScreenCoordinates).simplify(this.transformToScreenCoordinates, fsHints, qHints).collapseCollections().build();
        }
        catch (FactoryException e) {
            throw new ServiceException((Throwable)e);
        }
        return pipeline;
    }

    void run(FeatureCollection<?, ?> features, Pipeline pipeline, GeometryDescriptor geometryDescriptor, VectorTileBuilder vectorTileBuilder, Layer layer, boolean labelPoint, String layerName, boolean coalesce) {
        Stopwatch sw = Stopwatch.createStarted();
        int count = 0;
        int total = 0;
        String geometryName = geometryDescriptor.getName().getLocalPart();
        try (VTIterator it = VTIterator.getIterator(features.features(), coalesce);){
            while (it.hasNext()) {
                Geometry finalGeom;
                VTFeature feature = it.next();
                ++total;
                Geometry originalGeom = feature.getGeometry();
                if (labelPoint) {
                    originalGeom = this.getLabelPoint(originalGeom);
                }
                try {
                    finalGeom = pipeline.execute(originalGeom);
                }
                catch (Exception processingException) {
                    LOGGER.log(Level.WARNING, processingException.getLocalizedMessage(), processingException);
                    continue;
                }
                if (finalGeom.isEmpty()) continue;
                String featureId = feature.getFeatureId();
                Map<String, Object> properties = feature.getProperties();
                vectorTileBuilder.addFeature(layerName, featureId, geometryName, finalGeom, properties);
                ++count;
            }
        }
        sw.stop();
        if (LOGGER.isLoggable(Level.FINE)) {
            String msg = String.format("Added %,d out of %,d features of '%s' in %s", count, total, layer.getTitle(), sw);
            LOGGER.fine(msg);
        }
    }

    private Geometry getLabelPoint(Geometry originalGeom) {
        if (originalGeom instanceof Polygon || originalGeom instanceof MultiPolygon) {
            return PolygonLabelProcess.PolyLabeller((Geometry)originalGeom, null);
        }
        return originalGeom;
    }

    public MapProducerCapabilities getCapabilities(String format) {
        return null;
    }
}

