/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.mapbox;

import java.awt.Rectangle;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import no.ecc.vectortile.VectorTileEncoder;
import no.ecc.vectortile.VectorTileEncoderNoClip;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.map.RawMap;
import org.geoserver.wms.vector.VectorTileBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;

public class MapBoxTileBuilder
implements VectorTileBuilder {
    private static final Logger LOGGER = Logging.getLogger(MapBoxTileBuilder.class);
    private VectorTileEncoder encoder;

    public MapBoxTileBuilder(Rectangle mapSize, ReferencedEnvelope mapArea) {
        int extent = Math.max(mapSize.width, mapSize.height);
        int polygonClipBuffer = extent / 32;
        boolean autoScale = false;
        this.encoder = new VectorTileEncoderNoClip(extent, polygonClipBuffer, false);
    }

    @Override
    public void addFeature(String layerName, String featureId, String geometryName, Geometry geometry, Map<String, Object> properties) {
        int id = -1;
        if (featureId.matches(".*\\.[0-9]+")) {
            try {
                id = Integer.parseInt(featureId.split("\\.")[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (id < 0) {
            LOGGER.warning("Cannot obtain numeric id from featureId: " + featureId);
        }
        this.encoder.addFeature(layerName, properties, geometry, (long)id);
    }

    public RawMap build(WMSMapContent mapContent) throws IOException {
        byte[] contents = this.encoder.encode();
        return new RawMap(mapContent, contents, "application/vnd.mapbox-vector-tile");
    }
}

