/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import java.util.Arrays;
import java.util.List;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.filter.sort.SortOrder;
import org.geotools.factory.CommonFactoryFinder;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

@Component
public class SortByConverter
implements Converter<String, SortBy[]> {
    static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();

    public static final SortBy[] convertList(List<String> sortBy) {
        return (SortBy[])sortBy.stream().map(s -> SortByConverter.sortBy(s)).toArray(SortBy[]::new);
    }

    public static final SortBy[] convertString(String spec) {
        return (SortBy[])Arrays.stream(spec.split("\\s*,\\s*")).map(s -> SortByConverter.sortBy(s)).toArray(SortBy[]::new);
    }

    private static SortBy sortBy(String spec) {
        SortOrder order = SortOrder.ASCENDING;
        if (spec.startsWith("+")) {
            spec = spec.substring(1);
        } else if (spec.startsWith("-")) {
            spec = spec.substring(1);
            order = SortOrder.DESCENDING;
        }
        return FF.sort(spec, order);
    }

    public SortBy[] convert(String spec) {
        return SortByConverter.convertString(spec);
    }
}

