/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.Map;
import org.locationtech.jts.geom.Geometry;

public enum AttributeType {
    STRING("string"),
    URI("uri"),
    ENUMERATION("enum"),
    NUMBER("number"),
    INTEGER("integer"),
    BOOL("boolean"),
    GEOMETRY("geometry");

    String type;
    private static final Map<Class<?>, Class<?>> PRIMITIVES_TO_WRAPPERS;

    private AttributeType(String type) {
        this.type = type;
    }

    @JsonValue
    public String getType() {
        if (this.type != null) {
            return this.type;
        }
        return this.name();
    }

    public String toString() {
        return this.getType();
    }

    public static AttributeType fromClass(Class<?> binding) {
        if (binding == null) {
            return STRING;
        }
        if (PRIMITIVES_TO_WRAPPERS.containsKey(binding)) {
            binding = PRIMITIVES_TO_WRAPPERS.get(binding);
        }
        if (Number.class.isAssignableFrom(binding)) {
            if (Float.class.isAssignableFrom(binding) || Double.class.isAssignableFrom(binding) || BigDecimal.class.isAssignableFrom(binding)) {
                return NUMBER;
            }
            return INTEGER;
        }
        if (Boolean.class.isAssignableFrom(binding)) {
            return BOOL;
        }
        if (Geometry.class.isAssignableFrom(binding)) {
            return GEOMETRY;
        }
        return STRING;
    }

    static {
        PRIMITIVES_TO_WRAPPERS = new ImmutableMap.Builder().put(Boolean.TYPE, Boolean.class).put(Byte.TYPE, Byte.class).put(Character.TYPE, Character.class).put(Double.TYPE, Double.class).put(Float.TYPE, Float.class).put(Integer.TYPE, Integer.class).put(Long.TYPE, Long.class).put(Short.TYPE, Short.class).put(Void.TYPE, Void.class).build();
    }
}

