/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.geootols.filter.text.cql_2.CQL2;
import org.geoserver.ogcapi.InvalidParameterValueException;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FilterFactoryImpl;
import org.geotools.filter.spatial.DefaultCRSFilterVisitor;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.cqljson.CQLJsonCompiler;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;

public class APIFilterParser {
    private static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();
    public static String CQL_TEXT = "cql-text";
    public static String ECQL_TEXT = "ecql-text";
    public static String CQL2_TEXT = "cql2-text";
    public static String CQL2_JSON = "cql2-json";
    public static Set<String> SUPPORTED_ENCODINGS = new LinkedHashSet<String>(Arrays.asList(ECQL_TEXT, CQL2_TEXT, CQL2_JSON));

    public Filter parse(String filter, String filterLang) {
        return this.parse(filter, filterLang, null);
    }

    public Filter parse(String filter, String filterLang, String filterCRS) {
        if (filter == null) {
            return null;
        }
        if (CQL_TEXT.equals(filterLang)) {
            filterLang = ECQL_TEXT;
        }
        if (filterLang == null) {
            filterLang = CQL2_TEXT;
        }
        DefaultGeographicCRS queryCRS = DefaultGeographicCRS.WGS84;
        if (filterCRS != null) {
            try {
                queryCRS = CRS.decode((String)filterCRS);
            }
            catch (FactoryException e) {
                throw new InvalidParameterValueException(e.getMessage(), e);
            }
        }
        if (filterLang != null && !SUPPORTED_ENCODINGS.contains(filterLang)) {
            throw new InvalidParameterValueException("Only supported filter-lang options at the moment are " + SUPPORTED_ENCODINGS + " but '" + filterLang + "' was found instead");
        }
        try {
            Filter parsedFilter = null;
            if (ECQL_TEXT.equals(filterLang)) {
                parsedFilter = ECQL.toFilter((String)filter);
            } else if (CQL2_JSON.equals(filterLang)) {
                CQLJsonCompiler cqlJsonCompiler = new CQLJsonCompiler(filter, (FilterFactory)new FilterFactoryImpl());
                cqlJsonCompiler.compileFilter();
                parsedFilter = cqlJsonCompiler.getFilter();
            } else {
                parsedFilter = CQL2.toFilter((String)filter);
            }
            if (parsedFilter != null) {
                DefaultCRSFilterVisitor crsDefaulter = new DefaultCRSFilterVisitor(FF, (CoordinateReferenceSystem)queryCRS);
                parsedFilter = (Filter)parsedFilter.accept((FilterVisitor)crsDefaulter, null);
                return parsedFilter;
            }
            return null;
        }
        catch (CQLException e) {
            throw new InvalidParameterValueException(e.getMessage(), e);
        }
    }
}

