/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.features;

import javax.servlet.http.HttpServletResponse;
import org.geoserver.ogcapi.v1.features.FeaturesResponse;
import org.geoserver.ows.AbstractDispatcherCallback;
import org.geoserver.ows.Request;
import org.geoserver.ows.Response;
import org.geoserver.platform.Operation;
import org.geoserver.wfs.request.FeatureCollectionResponse;

public class HttpHeaderLinksAppender
extends AbstractDispatcherCallback {
    public Response responseDispatched(Request request, Operation operation, Object result, Response response) {
        if (result instanceof FeaturesResponse) {
            HttpServletResponse httpResponse = request.getHttpResponse();
            FeatureCollectionResponse fcr = ((FeaturesResponse)((Object)result)).getResponse();
            String contentType = response.getMimeType(result, operation);
            if (fcr.getPrevious() != null) {
                this.addLink(httpResponse, "prev", contentType, fcr.getPrevious());
            }
            if (fcr.getNext() != null) {
                this.addLink(httpResponse, "next", contentType, fcr.getNext());
            }
        }
        return response;
    }

    private void addLink(HttpServletResponse httpResponse, String rel, String contentType, String href) {
        String headerValue = String.format("<%s>; rel=\"%s\"; type=\"%s\"", href, rel, contentType);
        httpResponse.addHeader("Link", headerValue);
    }
}

